/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddMeasureAction extends Action{
    public static final String NAME = "action.measure.add";

    public AddMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        final int number = showDialog();
        if(number > 0 && number <=  (getSongManager().countMeasures() + 1)){
        	new Thread(new Runnable() {
				public void run() {						
					new SyncThread(new Runnable() {
						public void run() {
				            //comienza el undoable
				        	UndoableAddMeasure undoable = UndoableAddMeasure.startUndo(number);    	        	
				        	
				        	getSongManager().addNewMeasure(number);                
				        	updateTablature();
				        	
				        	int trackNumber = getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber();
				        	int stringNumber = getEditor().getTablature().getCaret().getStringNumber();
				        	long start = getSongManager().getMeasureHeader(number).getStart();
				        	getEditor().getTablature().getCaret().update(trackNumber,start,stringNumber);
				        	
				            //termia el undoable
				        	getEditor().getUndoManager().addEdit(undoable.endUndo());
				        				        	 
				        	redraw();
				        	TuxGuitar.instance().updateCache(true);
						}
					}).start();
				}
			}).start();        	
        }
	    return false;
    }

    private int selectedNumber;
    public int showDialog() {
    	this.selectedNumber = -1;
        if (getEditor().getTablature().getCaret().getMeasureCoords() != null) {
        	final Shell shell = TuxGuitar.instance().getShell(); 
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);  
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("measure.add"));
            

            //----------------------------------------------------------------------
            Composite radios = new Composite(dialog,SWT.NONE);
            radios.setLayout(new GridLayout());     
            radios.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            
            final Button beforePosition = new Button(radios,SWT.RADIO);
            beforePosition.setText(TuxGuitar.getProperty("measure.add-before-current-position"));
            
            final Button afterPosition = new Button(radios,SWT.RADIO);
            afterPosition.setText(TuxGuitar.getProperty("measure.add-after-current-position"));
            
            
            final Button atEnd = new Button(radios,SWT.RADIO);
            atEnd.setText(TuxGuitar.getProperty("measure.add-at-end"));                                   
            atEnd.setSelection(true);
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;     
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                	if(beforePosition.getSelection()){
                		selectedNumber = (getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
                	}else if(afterPosition.getSelection()){
                		selectedNumber = (getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber() + 1);
                	}else if(atEnd.getSelection()){
                		selectedNumber = (getSongManager().countMeasures() + 1);
                	}
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);            
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }

            }	
        }
        return this.selectedNumber;
    }    
}
