/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableRemoveTrack;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RemoveTrackAction extends Action{
    public static final String NAME = "action.track.remove";
    
    public RemoveTrackAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {    	
        Caret caret = getEditor().getTablature().getCaret();        
        SongCoords songCoords = caret.getSongCoords();

        if(getSongManager().countTracks() <= 1){
        	TuxGuitar.instance().getSongManager().newSong();
        	getEditor().resetDefaults();
        	TuxGuitar.instance().getMixer().update();
        	TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();        	
        	redraw();
        	return true;
        }
        //comienza el undoable
        UndoableRemoveTrack undoable = UndoableRemoveTrack.startUndo(); 	
        
	    SongTrackCoords track = caret.getSongTrackCoords();     
	    SongTrackCoords nextCaretTrack = caret.getSongCoords().getNextTrack(track);
	    if(nextCaretTrack == null){
	        nextCaretTrack = caret.getSongCoords().getPrevTrack(track);
	    }        	    
	    getSongManager().removeTrack(track.getTrack());
	    updateTablature();        	    
	    
	    //move the caret to the next or previous track
	    if(nextCaretTrack != null){
	        caret.update(nextCaretTrack.getTrack().getNumber(),nextCaretTrack.getMeasureCoords(caret.getMeasureCoords().getMeasure().getStart()).getMeasure().getStart(),1);        	    
	    }
	    TuxGuitar.instance().getMixer().update();
	    redraw(); 
	    
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo()); 
	    
	    return true;
    }

}
