package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassLoaderUtil {

	private static URL[] toURL(String path){
		try {
			return new URL[]{ new File(path).toURL() };
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}		
		return new URL[]{};
	}
	
	public static Object newInstance(String loadClassName,String loadClassPath){													
		return newInstance(loadClassName,toURL(loadClassPath));		
	}
	
	public static Object newInstance(String loadClassName){													
		return newInstance(loadClassName,new URL[]{});		
	}
	
	public static Object newInstance(String loadClassName,URL[] urls){								
		Object object = null;
		try {
			object = new URLClassLoader(urls).loadClass(loadClassName).newInstance();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}		
		return object;
	}	

}
