/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureHeader implements Serializable{
	public static final int TRIPLET_FEEL_NONE = 1;
	public static final int TRIPLET_FEEL_EIGHTH = 2;
	public static final int TRIPLET_FEEL_SIXTEENTH = 3;
	
    private int number;
	private long start;
    private TimeSignature timeSignature;
    private Tempo tempo;
    private Marker marker;
    private boolean repeatStart;    
    private int numberOfRepetitions;
    private int tripletFeel;
    private long startWidthRepetitions;
    
    public MeasureHeader(int number,long start,TimeSignature timeSignature,Tempo tempo,Marker marker,int tripletFeel,boolean repeatStart,int numberOfRepetitions){
        this.number = number;
    	this.start = start;
        this.timeSignature = timeSignature;
        this.tempo = tempo;
        this.marker = marker;
        this.tripletFeel = tripletFeel;
        this.repeatStart = repeatStart;
        this.numberOfRepetitions = numberOfRepetitions;
        this.startWidthRepetitions = this.start;
        this.checkMarker();
    }

    public int getNumber() {
		return number;
	}

	public void setNumber(int number) {
		this.number = number;
		this.checkMarker();
	}

	public int getNumberOfRepetitions() {
		return numberOfRepetitions;
	}

	public void setNumberOfRepetitions(int numberOfRepetitions) {
		this.numberOfRepetitions = numberOfRepetitions;
	}

	public boolean isRepeatStart() {
		return repeatStart;
	}

	public void setRepeatStart(boolean repeatStart) {
		this.repeatStart = repeatStart;
	}

	public long getStart() {
		return start;
	}

	public void setStart(long start) {
		this.start = start;
	}

	
	
	public int getTripletFeel() {
		return tripletFeel;
	}

	public void setTripletFeel(int tripletFeel) {
		this.tripletFeel = tripletFeel;
	}

	public long getStartWidthRepetitions() {
		return startWidthRepetitions;
	}

	public void setStartWidthRepetitions(long startWidthRepetitions) {
		this.startWidthRepetitions = startWidthRepetitions;
	}

	public Tempo getTempo() {
		return tempo;
	}

	public void setTempo(Tempo tempo) {
		this.tempo = tempo;
	}

	public TimeSignature getTimeSignature() {
		return timeSignature;
	}

	public void setTimeSignature(TimeSignature timeSignature) {
		this.timeSignature = timeSignature;
	}

	
	
	public Marker getMarker() {
		return marker;
	}

	public void setMarker(Marker marker) {
		this.marker = marker;
	}

	public boolean hasMarker(){
		return (getMarker() != null);
	}
	
	private void checkMarker(){
		if(hasMarker()){
			marker.setMeasure(getNumber());
		}
	}
	
	public long getLength(){
        return getTimeSignature().getNumerator() * getTimeSignature().getDenominator().getTime();
    }    
    
    public void makeEqual(MeasureHeader measure){
        this.start = measure.getStart();
        this.timeSignature = measure.getTimeSignature();
        this.tempo = measure.getTempo();
        this.marker = measure.getMarker();
        this.repeatStart = measure.isRepeatStart();
        this.numberOfRepetitions = measure.getNumberOfRepetitions();
        this.startWidthRepetitions = measure.getStartWidthRepetitions();    
        this.checkMarker();
    }
    
    public Object clone(){
    	int number = this.number;
        long start = this.start;
        boolean repeatStart = this.repeatStart;
        int numberOfRepetitions = this.numberOfRepetitions;
        int tripletFeel = this.tripletFeel;
        TimeSignature timeSignature = (TimeSignature)this.timeSignature.clone();
        Tempo tempo = (Tempo)this.tempo.clone();
        Marker marker = null;
        if(getMarker() != null){
        	marker = (Marker)getMarker().clone();
        	marker.setMeasure(number);
        }
        return new MeasureHeader(number,start,timeSignature,tempo,marker,tripletFeel,repeatStart,numberOfRepetitions);
    }
    
}
