/*
 * c64exp-cmdline-options.c
 *
 * Written by
 *  Andreas Boose <viceteam@t-online.de>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#include <stdio.h>

#include "c64exp-cmdline-options.h"
#include "cmdline.h"
#include "drive.h"
#include "lib.h"


#ifdef HAS_TRANSLATION
#include "translate.h"

static const cmdline_option_t cmdline_options[] = {
    { "-profdos1571", SET_RESOURCE, 1, NULL, NULL, "DriveProfDOS1571Name", NULL,
      IDCLS_P_NAME, IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME },
    { NULL }
};

static cmdline_option_t cmd_drive[] = {
    { NULL, SET_RESOURCE, 1, NULL, NULL, NULL, (void *)DRIVE_PC_NONE,
      IDCLS_P_TYPE,
      IDCLS_PAR_CABLE_C64EXP_TYPE },
    { NULL, SET_RESOURCE, 0, NULL, NULL, NULL, (void *)1,
      0, IDCLS_ENABLE_PROFDOS },
    { NULL, SET_RESOURCE, 0, NULL, NULL, NULL, (void *)0,
      0, IDCLS_DISABLE_PROFDOS },
    { NULL }
};
#else
static const cmdline_option_t cmdline_options[] = {
    { "-profdos1571", SET_RESOURCE, 1, NULL, NULL, "DriveProfDOS1571Name", NULL,
      N_("<name>"), N_("Specify name of Professional DOS 1571 ROM image") },
    { NULL }
};

static cmdline_option_t cmd_drive[] = {
    { NULL, SET_RESOURCE, 1, NULL, NULL, NULL, (void *)DRIVE_PC_NONE,
      N_("<type>"),
      N_("Set parallel cable type (0: none, 1: standard, 2: Dolphin DOS 3)") },
    { NULL, SET_RESOURCE, 0, NULL, NULL, NULL, (void *)1,
      NULL, N_("Enable Professional DOS") },
    { NULL, SET_RESOURCE, 0, NULL, NULL, NULL, (void *)0,
      NULL, N_("Disable Professional DOS") },
    { NULL }
};
#endif

int c64exp_cmdline_options_init(void)
{
    unsigned int dnr, i;

    for (dnr = 0; dnr < DRIVE_NUM; dnr++) {
        cmd_drive[0].name = lib_msprintf("-parallel%i", dnr + 8);
        cmd_drive[0].resource_name
            = lib_msprintf("Drive%iParallelCable", dnr + 8);
        cmd_drive[1].name = lib_msprintf("-drive%iprofdos", dnr + 8);
        cmd_drive[1].resource_name
            = lib_msprintf("Drive%iProfDOS", dnr + 8);
        cmd_drive[2].name = lib_msprintf("+drive%iprofdos", dnr + 8);
        cmd_drive[2].resource_name
            = lib_msprintf("Drive%iProfDOS", dnr + 8);

        if (cmdline_register_options(cmd_drive) < 0)
            return -1;

        for (i = 0; i < 3; i++) {
            lib_free((char *)cmd_drive[i].name);
            lib_free((char *)cmd_drive[i].resource_name);
        }
    }

    return cmdline_register_options(cmdline_options);
}

