// $Id: printprg.h 1593 2006-07-29 11:22:30Z alex $
/* @@tag:xara-cn@@ DO NOT MODIFY THIS LINE
================================XARAHEADERSTART===========================
 
               Xara LX, a vector drawing and manipulation program.
                    Copyright (C) 1993-2006 Xara Group Ltd.
       Copyright on certain contributions may be held in joint with their
              respective authors. See AUTHORS file for details.

LICENSE TO USE AND MODIFY SOFTWARE
----------------------------------

This file is part of Xara LX.

Xara LX is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License version 2 as published
by the Free Software Foundation.

Xara LX and its component source files are distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with Xara LX (see the file GPL in the root directory of the
distribution); if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


ADDITIONAL RIGHTS
-----------------

Conditional upon your continuing compliance with the GNU General Public
License described above, Xara Group Ltd grants to you certain additional
rights. 

The additional rights are to use, modify, and distribute the software
together with the wxWidgets library, the wxXtra library, and the "CDraw"
library and any other such library that any version of Xara LX relased
by Xara Group Ltd requires in order to compile and execute, including
the static linking of that library to XaraLX. In the case of the
"CDraw" library, you may satisfy obligation under the GNU General Public
License to provide source code by providing a binary copy of the library
concerned and a copy of the license accompanying it.

Nothing in this section restricts any of the rights you have under
the GNU General Public License.


SCOPE OF LICENSE
----------------

This license applies to this program (XaraLX) and its constituent source
files only, and does not necessarily apply to other Xara products which may
in part share the same code base, and are subject to their own licensing
terms.

This license does not apply to files in the wxXtra directory, which
are built into a separate library, and are subject to the wxWindows
license contained within that directory in the file "WXXTRA-LICENSE".

This license does not apply to the binary libraries (if any) within
the "libs" directory, which are subject to a separate license contained
within that directory in the file "LIBS-LICENSE".


ARRANGEMENTS FOR CONTRIBUTION OF MODIFICATIONS
----------------------------------------------

Subject to the terms of the GNU Public License (see above), you are
free to do whatever you like with your modifications. However, you may
(at your option) wish contribute them to Xara's source tree. You can
find details of how to do this at:
  http://www.xaraxtreme.org/developers/

Prior to contributing your modifications, you will need to complete our
contributor agreement. This can be found at:
  http://www.xaraxtreme.org/developers/contribute/

Please note that Xara will not accept modifications which modify any of
the text between the start and end of this header (marked
XARAHEADERSTART and XARAHEADEREND).


MARKS
-----

Xara, Xara LX, Xara X, Xara X/Xtreme, Xara Xtreme, the Xtreme and Xara
designs are registered or unregistered trademarks, design-marks, and/or
service marks of Xara Group Ltd. All rights in these marks are reserved.


      Xara Group Ltd, Gaddesden Place, Hemel Hempstead, HP2 6EX, UK.
                        http://www.xara.com/

=================================XARAHEADEREND============================
 */

// Holds most of the OIL-y printing facilities used by ScreenCamView.

//	WEBSTER-ranbirr-12/11/96
#ifndef WEBSTER

#ifndef INC_PRINTPRG
#define INC_PRINTPRG

#define OPTOKEN_PRINT_PROGRESS _T("PrintProgress")

/********************************************************************************************

>	class PrintProgressDlg : public CDialog

	Author:		Mark_Neves (Xara Group Ltd) <camelotdev@xara.com>
	Created:	28/4/95
	Purpose:	Maintains the print progress dialog which shows the user how the print is
				going and also allows them to cancel the print at any time.

				I copied Tim's stuff in prncamvw.h & .cpp and developed this lot from there.
	SeeAlso:	

********************************************************************************************/

class PrintProgressDlg : public DialogOp
{
	CC_DECLARE_DYNCREATE( PrintProgressDlg )  
public:
	PrintProgressDlg();
	virtual ~PrintProgressDlg() { pPrintProgressDlg = NULL; if (pDisabler) { delete pDisabler; pDisabler=NULL;} }

	MsgResult Message( Msg* Message );  
	void Do(OpDescriptor*);		// "Do" function        
	static BOOL Init();
	static OpState GetState(String_256*, OpDescriptor*);	

	static const UINT32 IDD;
	static const CDlgMode Mode;
	static BOOL Aborted;

public:
//	virtual BOOL OnInitDialog();
//	virtual void OnCancel();

	void SetSliderMax(INT32 max);
	void SetSliderPos(INT32 pos);

	void SetSliderSubRangeMax(INT32 Max);
	void SetSliderSubRangePos(INT32 Pos);


public:
	void SetDocName(LPCTSTR pDocName);
	void SetPrinterName(LPCTSTR pPrinterName);
	void SetPortName(LPCTSTR pPortName);
	void SetPageNumber( INT32 PageNumber,  INT32 MaxPageNumber,
						INT32 PlateNumber, INT32 MaxPlateNumber, LPCTSTR pPlateName,
						INT32 TileNumber,  INT32 MaxTileNumber);

	// While the dlg is Locked, calls to SetPageNumber functions will be ignored
	void LockProgressUpdate(BOOL Locked) { IgnoreUpdates = Locked; }

	void Done() {Close(); End();}

public:
	void SetAnalysing()	{ Printing = FALSE; }
	void SetPrinting()  { Printing = TRUE;  }


private:
	INT32 SliderMax;
	INT32 SliderCurPercent;	// Current percentage the slider is representing (between 0 to 100)

	INT32 SliderSubRangeMax;
	INT32 SliderSubRangeBase;
	INT32 SliderSubRangeStep;

	BOOL Printing;

	BOOL IgnoreUpdates;				// TRUE if the dlg is locked against showing any updated info

	MonotonicTime UpdateTime;

public:
	// The call back function for the print dialog.
	static BOOL AbortProc();

private:
	static PrintProgressDlg* pPrintProgressDlg;		// Ptr to dlg used by AbortProc()

	wxWindowDisabler * pDisabler;

public:
	static PrintProgressDlg * Get() {return pPrintProgressDlg;}
};


#endif  // INC_PRINTPRG

#endif //webster
