/*
 * xmmplayer - mplayer plugin for xmms
 * Copyright (C) 2003 Hyriand - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"
#include "xmmplayer.h"

#include <gtk/gtk.h>
#include <glib.h>

#define ADD_LINE(label, item) \
  { \
    item_label = gtk_label_new(label); \
    value_label = gtk_label_new(item); \
    gtk_box_pack_start (GTK_BOX (items_vbox), item_label, FALSE, FALSE, 0); \
    gtk_box_pack_start (GTK_BOX (values_vbox), value_label, FALSE, FALSE, 0); \
  }

static void
fileinfo_close (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (GTK_WIDGET (data));
}

void
xmmplayer_file_info_box (char *filename)
{
  GtkWidget *win, *vbox, *hbox, *frame, *frame_vbox, *frame_hbox, *items_vbox,
    *values_vbox, *item_label, *value_label;
  _xmmplayer_info info;

  xmmplayer_ident_file (filename, &info, 1);

  win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_container_set_border_width (GTK_CONTAINER (win), 10);
  gtk_window_set_title (GTK_WINDOW (win), "File info");
  gtk_window_set_policy (GTK_WINDOW (win), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (win), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &win);

  vbox = gtk_vbox_new (FALSE, 10);

  frame = gtk_frame_new ("File info:");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  frame_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (frame_vbox), 5);

  hbox = gtk_hbox_new (FALSE, 10);
  item_label = gtk_label_new ("title:");
  gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
  item_label = gtk_label_new (filename);
  gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (frame_vbox), hbox, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 10);
  item_label = gtk_label_new ("length:");
  gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
  item_label =
    gtk_label_new (g_strdup_printf
		   ("%i:%02i", info.length / 60000,
		    (info.length / 1000) % 60));
  gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (frame_vbox), hbox, FALSE, FALSE, 0);

  if (strcmp (filename, "vcd://") == 0)
    {
      hbox = gtk_hbox_new (FALSE, 10);
      item_label = gtk_label_new ("tracks:");
      gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
      item_label = gtk_label_new (g_strdup_printf ("%i", info.tracks));
      gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (frame_vbox), hbox, FALSE, FALSE, 0);
    }

  if (strcmp (filename, "dvd://") == 0)
    {
      hbox = gtk_hbox_new (FALSE, 10);
      item_label = gtk_label_new ("titles:");
      gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
      item_label = gtk_label_new (g_strdup_printf ("%i", info.titles));
      gtk_box_pack_start (GTK_BOX (hbox), item_label, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (frame_vbox), hbox, FALSE, FALSE, 0);
    }

  gtk_container_add (GTK_CONTAINER (frame), frame_vbox);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  if (info.clip_info)
    {
      frame = gtk_frame_new ("Clip info");
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      frame_vbox = gtk_vbox_new (FALSE, 5);
      gtk_container_set_border_width (GTK_CONTAINER (frame_vbox), 5);
      item_label = gtk_label_new (info.clip_info);
      gtk_box_pack_start (GTK_BOX (frame_vbox), item_label, FALSE, FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), frame_vbox);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
    }

  hbox = gtk_hbox_new (FALSE, 5);
  frame = gtk_frame_new ("Video");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  frame_hbox = gtk_hbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (frame_hbox), 5);
  items_vbox = gtk_vbox_new (FALSE, 5);
  values_vbox = gtk_vbox_new (FALSE, 5);
  ADD_LINE ("Format:", info.video_format);
  if (info.video_bitrate != 0)
    ADD_LINE ("Bitrate:",
	      g_strdup_printf ("%i kbit/s", info.video_bitrate / 1000))
  else
    ADD_LINE ("Bitrate:", "unknown")
  if ((info.video_width != -1) && (info.video_height != 0))
    ADD_LINE ("Resolution:",
	      g_strdup_printf ("%i x %i", info.video_width,
			       info.video_height))
  else
    ADD_LINE ("Resolution:", "unknown")
  if (info.video_bitrate != 0)
    ADD_LINE ("FPS:", g_strdup_printf ("%.2f", info.fps))
  else
    ADD_LINE ("FPS:", "unknown")
  if (info.video_aspect != 0.0)
    ADD_LINE ("Aspect ratio:",
	      g_strdup_printf ("1 : %.2f", info.video_aspect))
  else
    ADD_LINE ("Aspect ratio:", "unknown")
  gtk_box_pack_start (GTK_BOX (frame_hbox), items_vbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (frame_hbox), values_vbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), frame_hbox);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);

  frame = gtk_frame_new ("Audio");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  frame_hbox = gtk_hbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (frame_hbox), 5);
  items_vbox = gtk_vbox_new (FALSE, 5);
  values_vbox = gtk_vbox_new (FALSE, 5);
  ADD_LINE ("Codec:", info.audio_codec);
  ADD_LINE ("Bitrate:",
	    g_strdup_printf ("%i kbit/s", info.audio_bitrate / 1000));
  ADD_LINE ("Frequency:", g_strdup_printf ("%i KHz", info.audio_rate / 1000));
  ADD_LINE ("Channels:", g_strdup_printf ("%i", info.audio_channels));
  gtk_box_pack_start (GTK_BOX (frame_hbox), items_vbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (frame_hbox), values_vbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), frame_hbox);
  gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  item_label = gtk_button_new_with_label ("Ok");
  gtk_signal_connect (GTK_OBJECT (item_label), "clicked",
		      GTK_SIGNAL_FUNC (fileinfo_close), win);
  GTK_WIDGET_SET_FLAGS (item_label, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), item_label, TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (win), vbox);
  gtk_widget_show_all (win);

  xmmplayer_free_extended (&info);
}
