/*
 * xmms-mplayer - mplayer plugin for xmms
 * Copyright (C) 2003 Hyriand - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef XMMPLAYER_H
#define XMMPLAYER_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <xmms/plugin.h>
#include <xmms/titlestring.h>
#include <xmms/xmmsctrl.h>
#include "xmms.h"

void xmmsmplayer_error (char *fmt, ...);
void xmmplayer_write_config (void);
void xmmplayer_configure (void);

extern InputPlugin mplayer_plugin;   /**< the plugin itself */
extern int decode_thread;

typedef struct
{
  char identified;
  int length;
  int pos;
  float fps, video_aspect;
  int audio_bitrate;
  int audio_rate;
  int audio_channels;
  int tracks;
  int titles;
  int video_width, video_height;
  int video_bitrate;

  char *clip_info,
       *video_format,
       *audio_codec;
}
_xmmplayer_info;
extern _xmmplayer_info xmmplayer_info;

typedef struct
{
  gchar *mplayer_path;
  gchar *vo;
  gchar *ao;
  gboolean read_info;
  gboolean fullscreen;
  gboolean nocache;
  gboolean noninterleaved;
  gchar *tv_c;
  gint tv_w, tv_h;
#ifdef LINUX_RTC
  gboolean nortc;
#endif
  gint index;

  gboolean videowin_visible, videowin_autoclose, videowin_resize, videowin_scale;
  gint videowin_width, videowin_height, videowin_x, videowin_y;
}
_xmmplayer_config;
extern _xmmplayer_config xmmplayer_config;

void
xmmplayer_ident_file (char *url, _xmmplayer_info * info, int extended);
void
xmmplayer_free_extended(_xmmplayer_info * info);
void
xmmplayer_stop ();
void
xmmplayer_fullscreen (void);

#endif /* !XMMPLAYER_H */
