/*
 *               In the name of Allah
 * This file is part of The Zekr Project. Use is subject to
 * license terms.
 *
 * Author:         Mohsen Saboorian
 * Start Date:     Jan 20, 2006
 */
package net.sf.zekr.common.resource;

/**
 * This class contains some of Quran properties to be used in subclasses. All static Quran
 * configurations should be moved from quran-properties.xml into this class.
 * 
 * @author Mohsen Saboorian
 * @since Zekr 1.0
 * @version 0.2
 */
public abstract class QuranBaseProperties {
	protected static int[][] hizbQuads = {  // from Kuran0.08: http://kuran.sourceforge.net
			 {  1,  1}, {  2, 26}, {  2, 44}, {  2, 60}, {  2, 75}, {  2, 92}, {  2,106}, {  2,124},  //Juz  1 = Hizb  1 + Hizb  2
			 {  2,142}, {  2,158}, {  2,177}, {  2,189}, {  2,203}, {  2,219}, {  2,233}, {  2,243},  //Juz  2 = Hizb  3 + Hizb  4
			 {  2,253}, {  2,263}, {  2,272}, {  2,283}, {  3, 15}, {  3, 33}, {  3, 52}, {  3, 75},  //Juz  3 = Hizb  5 + Hizb  6
			 {  3, 93}, {  3,113}, {  3,133}, {  3,153}, {  3,171}, {  3,186}, {  4,  1}, {  4, 12},  //Juz  4 = Hizb  7 + Hizb  8
			 {  4, 24}, {  4, 36}, {  4, 58}, {  4, 74}, {  4, 88}, {  4,100}, {  4,114}, {  4,135},  //Juz  5 = Hizb  9 + Hizb 10
			 {  4,148}, {  4,163}, {  5,  1}, {  5, 12}, {  5, 27}, {  5, 41}, {  5, 51}, {  5, 67},  //Juz  6 = Hizb 11 + Hizb 12
			 {  5, 82}, {  5, 97}, {  5,109}, {  6, 13}, {  6, 36}, {  6, 59}, {  6, 74}, {  6, 95},  //Juz  7 = Hizb 13 + Hizb 14
			 {  6,111}, {  6,127}, {  6,141}, {  6,151}, {  7,  1}, {  7, 31}, {  7, 47}, {  7, 65},  //Juz  8 = Hizb 15 + Hizb 16
			 {  7, 88}, {  7,117}, {  7,142}, {  7,156}, {  7,171}, {  7,189}, {  8,  1}, {  8, 22},  //Juz  9 = Hizb 17 + Hizb 18
			 {  8, 41}, {  8, 61}, {  9,  1}, {  9, 19}, {  9, 34}, {  9, 46}, {  9, 60}, {  9, 75},  //Juz 10 = Hizb 19 + Hizb 20
			 {  9, 93}, {  9,111}, {  9,122}, { 10, 11}, { 10, 26}, { 10, 53}, { 10, 71}, { 10, 90},  //Juz 11 = Hizb 21 + Hizb 22
			 { 11,  6}, { 11, 24}, { 11, 41}, { 11, 61}, { 11, 84}, { 11,108}, { 12,  7}, { 12, 30},  //Juz 12 = Hizb 23 + Hizb 24
			 { 12, 53}, { 12, 77}, { 12,101}, { 13,  5}, { 13, 19}, { 13, 35}, { 14, 10}, { 14, 28},  //Juz 13 = Hizb 25 + Hizb 26
			 { 15,  1}, { 15, 50}, { 16,  1}, { 16, 30}, { 16, 51}, { 16, 75}, { 16, 90}, { 16,111},  //Juz 14 = Hizb 27 + Hizb 28
			 { 17,  1}, { 17, 23}, { 17, 50}, { 17, 70}, { 17, 99}, { 18, 17}, { 18, 32}, { 18, 51},  //Juz 15 = Hizb 29 + Hizb 30
			 { 18, 75}, { 18, 99}, { 19, 22}, { 19, 59}, { 20,  1}, { 20, 55}, { 20, 83}, { 20,111},  //Juz 16 = Hizb 31 + Hizb 32
			 { 21,  1}, { 21, 29}, { 21, 51}, { 21, 83}, { 22,  1}, { 22, 19}, { 22, 38}, { 22, 60},  //Juz 17 = Hizb 33 + Hizb 34
			 { 23,  1}, { 23, 36}, { 23, 75}, { 24,  1}, { 24, 21}, { 24, 35}, { 24, 53}, { 25,  1},  //Juz 18 = Hizb 35 + Hizb 36
			 { 25, 21}, { 25, 53}, { 26,  1}, { 26, 52}, { 26,111}, { 26,181}, { 27,  1}, { 27, 27},  //Juz 19 = Hizb 37 + Hizb 38
			 { 27, 56}, { 27, 82}, { 28, 12}, { 28, 29}, { 28, 51}, { 28, 76}, { 29,  1}, { 29, 26},  //Juz 20 = Hizb 39 + Hizb 40
			 { 29, 46}, { 30,  1}, { 30, 31}, { 30, 54}, { 31, 22}, { 32, 11}, { 33,  1}, { 33, 18},  //Juz 21 = Hizb 41 + Hizb 42
			 { 33, 31}, { 33, 51}, { 33, 60}, { 34, 10}, { 34, 24}, { 34, 46}, { 35, 15}, { 35, 41},  //Juz 22 = Hizb 43 + Hizb 44
			 { 36, 28}, { 36, 60}, { 37, 22}, { 37, 83}, { 37,145}, { 38, 21}, { 38, 52}, { 39,  8},  //Juz 23 = Hizb 45 + Hizb 46
			 { 39, 32}, { 39, 53}, { 40,  1}, { 40, 21}, { 40, 41}, { 40, 66}, { 41,  9}, { 41, 25},  //Juz 24 = Hizb 47 + Hizb 48
			 { 41, 47}, { 42, 13}, { 42, 27}, { 42, 51}, { 43, 24}, { 43, 57}, { 44, 17}, { 45, 12},  //Juz 25 = Hizb 49 + Hizb 50
			 { 46,  1}, { 46, 21}, { 47, 10}, { 47, 33}, { 48, 18}, { 49,  1}, { 49, 14}, { 50, 27},  //Juz 26 = Hizb 51 + Hizb 52
			 { 51, 31}, { 52, 24}, { 53, 26}, { 54,  9}, { 55,  1}, { 56,  1}, { 56, 75}, { 57, 16},  //Juz 27 = Hizb 53 + Hizb 54
			 { 58,  1}, { 58, 14}, { 59, 11}, { 60,  7}, { 62,  1}, { 63,  4}, { 65,  1}, { 66,  1},  //Juz 28 = Hizb 55 + Hizb 56
			 { 67,  1}, { 68,  1}, { 69,  1}, { 70, 19}, { 72,  1}, { 73, 20}, { 75,  1}, { 76, 19},  //Juz 29 = Hizb 57 + Hizb 58
			 { 78,  1}, { 80,  1}, { 82,  1}, { 84,  1}, { 87,  1}, { 90,  1}, { 94,  1}, {100,  9}   //Juz 30 = Hizb 59 + Hizb 60
		};

}
