// -*- C++ -*-
//
// RepositoryManager_Impl.h,v 1.1 2005/07/29 04:15:32 mxiong Exp

// ****  Code generated by the The ACE ORB (TAO) IDL Compiler ****
// TAO and the TAO IDL Compiler have been developed by:
//       Center for Distributed Object Computing
//       Washington University
//       St. Louis, MO
//       USA
//       http://www.cs.wustl.edu/~schmidt/doc-center.html
// and
//       Distributed Object Computing Laboratory
//       University of California at Irvine
//       Irvine, CA
//       USA
//       http://doc.ece.uci.edu/
// and
//       Institute for Software Integrated Systems
//       Vanderbilt University
//       Nashville, TN
//       USA
//       http://www.isis.vanderbilt.edu/
//
// Information about TAO is available at:
//     http://www.cs.wustl.edu/~schmidt/TAO.html

// TAO_IDL - Generated from 
// .\be\be_codegen.cpp:859



#ifndef REPOSITORYMANAGERI_H_
#define REPOSITORYMANAGERI_H_

///====================================================================
// filename: RepositoryManager_Impl.h
// Author: Stoyan Paunov	spaunov@isis.vanderbilt.edu
//
// Purpose: This class is the implementation class for the spec 
//          complient RepositoryManager
//


#include "RepositoryManagerS.h"
#include "DeploymentS.h"					//added for the deployment stuff

#include "ace/Hash_Map_Manager.h"			//for the ACE_Hash_Map_Manager
#include "ace/Null_Mutex.h"					//for ACE_Null_Mutex
#include "ace/RW_Mutex.h"					//for ACE_RW_Mutex
#include "ace/OS_NS_string.h"				//for ACE_CString
#include "ace/SString.h"


#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */


namespace
{
///DIRECTORY WHERE THE PACKAGES WILL BE STORED LOCALLY
const static char* RM_STORAGE_PATH = "./RepositoryDir";
}

class  CIAO_RepositoryManagerDaemon_i : public virtual POA_CIAO::RepositoryManagerDaemon, public virtual PortableServer::RefCountServantBase
{
public:
  //Constructor 
  CIAO_RepositoryManagerDaemon_i (CORBA::ORB_ptr the_orb);
  
  //Destructor 
  virtual ~CIAO_RepositoryManagerDaemon_i (void);
  
  virtual
  void shutdown (
      
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));
  
  virtual
  void installPackage (
      const char * installationName,
      const char * location
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ::Deployment::NameExists,
      ::Deployment::PackageError
    ));
  
  virtual
  void createPackage (
      const char * installationName,
      const ::Deployment::PackageConfiguration & package,
      const char * baseLocation,
      ::CORBA::Boolean replace
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ::Deployment::NameExists,
      ::Deployment::PackageError
    ));
  
  virtual
  ::Deployment::PackageConfiguration * findPackageByName (
      const char * name
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ::Deployment::NoSuchName
    ));
  
  virtual
  ::Deployment::PackageConfiguration * findPackageByUUID (
      const char * UUID
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ::Deployment::NoSuchName
    ));
  
  virtual
  ::CORBA::StringSeq * findNamesByType (
      const char * type
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));
  
  virtual
  ::CORBA::StringSeq * getAllNames (
      
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));
  
  virtual
  ::CORBA::StringSeq * getAllTypes (
      
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));
  
  virtual
  void deletePackage (
      const char * installationName
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ::Deployment::NoSuchName
    ));

  protected:

	  ///function to parse and return the PackageConfiguration
	  Deployment::PackageConfiguration* retrieve_PC (char* package, char* cwd);

	  ///function to extract all necessary files for parsing the PackageConfiguration
	  ///descriptor and populating the idl struct.
	  ///return 1 on success
	  ///      -1 on error

	  int extract_necessary_files (char* package, 
								   char* PID, 
								   ACE_CString& pcd_name);

	  ///function that writes out a file to a specified location on the hand disk
	  ///returns 1 on success
	  ///		-1 on error

	  int write_to_disk (const char* full_path, 
						 const CORBA::Octet* buffer, 
						 size_t length
						 );


	  ///function that writes out a file to a specified location on the hand disk
	  ///returns 1 on success
	  ///		 0 on already exists and replace == false
	  ///		-1 on error

	  int write_to_disk (const char* full_path, 
						 ACE_Message_Block& mb,
						 bool replace = true
						 );


	  ///function to read the contents of a file from disk into a CORBA::OctetSeq
	  ///returns a pointer to a CORBA::Octet buffer and updated the lenght on success 
	  ///		 0 on failure

	  CORBA::Octet* read_from_disk (const char* full_path, size_t &lenght);

  private:
	/// Cached information about the installed PackageConfigurations
	/// A separate map for the installation names and their UUID's
    /// Key:	PackageConfiguration name or its UUID (CString type)
    /// Value:	The location of the local copy of the package

	///Based on the synchronization needed we can parametrize this with either 
	///ACE_Null_Mutex or ACE_RW_Mutex

    typedef ACE_Hash_Map_Manager_Ex<ACE_CString,
                                    ACE_CString,
                                    ACE_Hash<ACE_CString>,
                                    ACE_Equal_To<ACE_CString>,
                                    ACE_RW_Mutex> PCMap;


	typedef PCMap::iterator PCMap_Iterator;

	//a hash map that associates the names of PackageConfigurations with their location
    PCMap names_;

	//a hash map that associates the UUIDs of PackageConfigurations with their location
	PCMap uuids_;

	CORBA::ORB_var the_orb_;

};


#endif /* REPOSITORYMANAGERI_H_  */

