// Activator_Loader.h,v 1.3 2005/04/12 22:18:48 michel_j Exp
#ifndef TAO_IMR_ACTIVATOR_LOADER_H
#define TAO_IMR_ACTIVATOR_LOADER_H

#include "ImR_Activator_i.h"
#include "Activator_Options.h"

#include "tao/Object_Loader.h"

#include "ace/Auto_Ptr.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class ImR_Activator_ORB_Runner;

class Activator_Export ImR_Activator_Loader : public TAO_Object_Loader
{
public:
  ImR_Activator_Loader(void);

  virtual int init (int argc, ACE_TCHAR *argv[] ACE_ENV_ARG_DECL);

  virtual int fini (void);

  virtual CORBA::Object_ptr create_object (CORBA::ORB_ptr orb,
                                           int argc,
                                           ACE_TCHAR *argv[]
                                           ACE_ENV_ARG_DECL)
     ACE_THROW_SPEC ((CORBA::SystemException));

 // Unlike other service objects, we have our own orb.
 int run(void);

private:
  ImR_Activator_i service_;
  Activator_Options opts_;
  ACE_Auto_Ptr<ImR_Activator_ORB_Runner> runner_;

private:
  ACE_UNIMPLEMENTED_FUNC (ImR_Activator_Loader (const ImR_Activator_Loader &))
  ACE_UNIMPLEMENTED_FUNC (ImR_Activator_Loader &operator = (const ImR_Activator_Loader &))
};

ACE_FACTORY_DECLARE (Activator, ImR_Activator_Loader)

#endif
