# ----------------------------------------------------------
# AdvaS Advanced Search 
# module for the successor variety
#
# (C) 2002 - 2005 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# ----------------------------------------------------------

# changed 2004-11-21

import string
from io import get_file_contents
from basicStrings import split_line

def calc_succ_variety (word_list, flag):
	"calculates the successor variety for a given number of words"

	# word_list: list of words
	# flag: 1 use word_list
	#       2 word_list is interpreted as a file name

	# define successor variety
	# -- TBD: encoding declaration to avoid encoding errors --
	# -- workaround: may lead to different results
	alphabet = "abcdefghijklmnopqrstuvwxyz' -+" # äöüß@' "
	letter = {}
	for i in alphabet:
		# create a dictionary for each letter
		succ_variety = {}

		# calc successor variety for each combination of letters
		for j in alphabet:
			# letter is not following
			succ_variety[j] = 0 
		# end for

		letter[i] = succ_variety
	# end if

	# check for file
	if (flag==2):
		# open given file for reading
		file_name = word_list

		word_list = get_file_contents (file_name)
		if (word_list==-1):
			# can't read from given file name
			return letter
		# end if
	# end if

	# get size of word_list
	list_length = len(word_list)

	# use an outer list range
	outer_list_range = range(0, list_length)

	for i in outer_list_range:
		# look at each word, remove upper letters and special chars
		original = string.lower(word_list[i])
		without_spec = split_line (original)

		# add additional blank, needed for calculating variety
		term = without_spec[0] + " "

		# get word length
		term_length = len(term)

		inner_range = range(0, term_length - 1)
		for j in inner_range:
			current_letter = term[j]
			next_letter = term[j+1]
#			print '%s %s = 1' % (current_letter, next_letter)

			# update letter table
			letter[current_letter][next_letter] = 1
		# end for
	# end for

	# calculate variety for each letter
	for i in alphabet:
		value = 0
		for j in alphabet:
			value = value + letter[i][j]
		# end for

		letter[i] = value
	# end for

	# return successor variety for given list
	return letter

