
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python class
#
# (C) 2003 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for testing idf
#
# ----------------------------------------------------------

# changed 2003-05-02

# import advas class
from advas_oo import Advas

# a line of text
line1 = "the shop opens at eight. it is still closed. do you like to wait here?"
line2 = "the shop is not here. cross the street and turn left before school."
line3 = "our daughter is not at home. she is at school."
line4 = "for better or worse, this will never end. what a shame for us."
line5 = "nobody knows why he did so. he used to work at school."
line6 = "the last sentence in this book was underlined. one page was missing."
line7 = line6
print line1
print line2
print line3
print line4
print line5
print line6 + "\n"

# define object
a = Advas()

# calculate tf for each text
tf1 = a.tf(line1)
tf2 = a.tf(line2)
tf3 = a.tf(line3)
tf4 = a.tf(line4)
tf5 = a.tf(line5)
tf6 = a.tf(line6)

# create a wordlist for calculating idf
a.merge_lists_idf(tf1, tf2, tf3, tf4, tf5, tf6, tf6)
idf_calc = a.get_list()

# calc idf
idf_calc_2 = a.idf(7, idf_calc)

# output each item and its idf
key = idf_calc_2.keys()
for item in key:
	print '%-20s (%1d) : %f' % (item, idf_calc[item], idf_calc_2[item])



