// ---------------------------------------------------------------------------
// - Method.hpp                                                              -
// - standard object library - generic method class definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_METHOD_HPP
#define  AFNIX_METHOD_HPP

#ifndef  AFNIX_STRING_HPP
#include "String.hpp"
#endif

namespace afnix {

  /// The Method class is a generic class which holds an object and a method
  /// name. When the object method is applied, the method call the apply method
  /// by name. This class is a convenient mechanism to hold a pointer to a 
  /// method in a generic way. A call can also be made by quark, that is a
  /// long id instead of a name.
  /// @author amaury darsch

  class Method : public Object {
  private:
    enum {QUARK, OBJECT} d_type;
    /// the object instance
    Object* p_object;
    /// the method valud
    union {
      long    qval;
      Object* oval;
    } d_method;
    /// the apply flag
    bool d_aflg;

  public:
    /// create a new method with a quark and an object
    /// @param quark  the method quark
    /// @param object the calling object
    Method (const long quark, Object* object);

    /// create a new method with a method object
    /// @param method the method object
    /// @param object the calling object
    Method (Object* method, Object* object);

    /// create a new method with a quark, an object and an apply flag
    /// @param quark  the method quark
    /// @param object the calling object
    /// @param aflg   the apply flag to set
    Method (const long quark, Object* object, const bool aflg);

    /// create a new method with a method object and an apply flag
    /// @param method the method object
    /// @param object the calling object
    /// @param aflg   the apply flag to set
    Method (Object* method, Object* object, const bool aflg);

    /// destroy this method instance
    ~Method (void);

    /// @return this class name
    String repr (void) const;

    /// make this method a shared object
    void mksho (void);

    /// @return the apply flag
    bool getaflg (void) const;

    /// set the apply flag
    /// @param aflg the apply flag to set
    void setaflg (const bool aflg);

  private:
    // make the copy constructor private
    Method (const Method&);
    // make the assignment operator private
    Method& operator = (const Method&);

  public:
    /// apply this object with a set of arguments
    /// @param robj the current runnable
    /// @param nset the current nameset
    /// @param args the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, Cons* args);

  public:
    // the memory allocation
    void* operator new    (const t_size size);
    void  operator delete (void* handle);
  };
}

#endif
