;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: SPRES-IMPL -*-
;;; Please do not edit this file.  It is auto-generated.

(in-package :spres-impl)

#+cmu (declaim (optimize (ext:inhibit-warnings 3)))


(defun print-header-document-header/docbook (obj doc context)
  "Prints the header of the document."
  (rule-notify-start :document-header/docbook)
  (block print-header
    (put doc "<?xml version='1.0'?>" (eol))
    (put doc
         "<!DOCTYPE book PUBLIC \"-//Norman Walsh//DTD DocBk XML V3.1.7//EN\"
               \""
         (db-get-dtd)
         "\" ")
    (when (and ?file-table (> (hash-table-count ?file-table) 0))
      (put doc "[" (eol))
      (loop for
            val
            being
            the
            hash-values
            of
            ?file-table
            for
            fname
            =
            (file-info-to-fname val)
            do
            (put doc
                 "<!ENTITY "
                 "fileX"
                 (make-valid-entity fname)
                 " "
                 "SYSTEM \""
                 fname
                 (get-file-extension doc)
                 "\">"
                 (eol)))
      (put doc "]"))
    (put doc ">" (eol))))



(defmethod print-header
           ((obj t) (doc docbook-document) (context (eql :document)))
           (let ((?obj obj) (?doc doc) (?context context))
             (print-header-document-header/docbook obj doc context)))

(defun print-header-book-header/docbook (obj doc context)
  "Prints a book header for docbook."
  (rule-notify-start :book-header/docbook)
  (block print-header
    (let* ((short-name (setting-or-default '("system" "name") ""))
           (info-list 'nil)
           (authors
            (list
             (setting-or-default '("system" "author" "name")
                                 "Unknown Author"))))
      (when (every #'lower-case-p short-name)
        (setf short-name (format nil "~@(~a~)" short-name)))
      (put doc "<title>" short-name " Reference Documentation</title>" (eol))
      (put doc "<bookinfo>" (eol))
      (put doc "<productname>" short-name "</productname>" (eol))
      (let ((date (albert-setting '("system" "date")))
            (version
             (setting-or-default '("system" "version" "number") "v1.0")))
        (unless date (setf date (get-date-string-for-today)))
        (unless date (setf date "2003"))
        (put doc "<productnumber>" version "</productnumber>" (eol))
        (put doc "<pubdate>" date "</pubdate>" (eol)))
      (when-bind (licencefile (albert-setting '("system" "licencefile")))
                 (when
                     (or (pathnamep licencefile)
                         (and (stringp licencefile)
                              (plusp (length licencefile))))
                   (cond
                    ((not (probe-file licencefile))
                     (albert-warn
                      "docbook> unable to find Legal Notice file ~s"
                      licencefile))
                    (t
                     (with-open-file (in-str licencefile :direction :input)
                       (put doc
                            "<legalnotice> <title>"
                            (albert-setting
                             '("albert" "presentation" "legalnotice" "title"))
                            "</title><programlisting><![CDATA["
                            (eol))
                       (loop for
                             x
                             =
                             (read-line in-str nil 'eof)
                             until
                             (eq x 'eof)
                             do
                             (progn
                              (loop for
                                    i
                                    from
                                    0
                                    for
                                    ch
                                    across
                                    x
                                    do
                                    (cond
                                     ((= (char-code ch) 12)
                                      (setf (schar x i) #\Space))
                                     (t nil)))
                              (put doc x (eol))))
                       (put doc
                            (eol)
                            "]]> </programlisting></legalnotice>"))))))
      (put doc "</bookinfo>" (eol))
      t)))



(defmethod print-header
           ((obj t) (doc docbook-document) (context (eql :book)))
           (let ((?obj obj) (?doc doc) (?context context))
             (print-header-book-header/docbook obj doc context)))

(defun present-object-tpl/docbook (obj doc context)
  "Toplevel Docbook basically"
  (rule-notify-start :tpl/docbook)
  (block present-object
    (when-verbose (albert-info "docbook> presenting toplevel to ~a" ?doc))
    (when-bind (better-dtd (albert-setting '("albert" "docbook" "dtd")))
               (setf (db-get-dtd) better-dtd))
    (print-header obj doc :book)
    (let* ((content (slot-value obj 'content))
           (indexable-stuff (notevery #'is-empty? content))
           (num-classes (hierarchy-size ?class-hierarchy))
           (hier-setting
            (albert-setting
             '("albert" "presentation" "index" "class-hierarchy")))
           (include-hier
            (cond ((eq hier-setting t) t)
                  ((integerp hier-setting) (<= hier-setting num-classes))
                  (t nil))))
      (dolist (i content)
        (unless (is-empty? i) (present-object i doc context)))
      (when
          (or
           (and indexable-stuff
                (albert-setting
                 '("albert" "presentation" "index" "global-index")))
           include-hier)
        (put doc "<reference id=\"indexReference\">" (eol))
        (put doc "  <title>" (get-word "Indexes" doc) "</title>" (eol))
        (when include-hier
          (when-verbose
           (albert-info "spres> writing class-hierarchy to book."))
          (register-separate-document
           (make-file-info :id
                           "class-hierarchy"
                           :dir
                           nil
                           :fname
                           (make-valid-entity "class-hierarchy")))
          (with-ok-document (doc "class-hierarchy" doc)
                            (put doc "<refentry id=\"classHierarchy\">" (eol))
                            (put doc
                                 "<refnamediv>"
                                 "<refname>"
                                 (get-word "Class Hierarchy" doc)
                                 "</refname>"
                                 "<refpurpose>Clickable index of all classes</refpurpose>"
                                 "</refnamediv>"
                                 (eol))
                            (put doc "<refsect1><title></title>" (eol))
                            (put doc "<programlisting>" (eol))
                            (print-class-hierarchy doc ?class-hierarchy 0)
                            (put doc "</programlisting>" (eol))
                            (put doc "</refsect1>" (eol))
                            (put doc "</refentry>" (eol))))
        (when
            (and indexable-stuff
                 (albert-setting
                  '("albert" "presentation" "index" "global-index")))
          (register-separate-document
           (make-file-info :id
                           "global-index"
                           :dir
                           nil
                           :fname
                           (make-valid-entity "global-index")))
          (with-ok-document (doc "global-index" doc)
                            (put doc "<refentry id=\"globalIndex\">" (eol))
                            (put doc
                                 "<refnamediv>"
                                 "<refname>"
                                 (get-word "Global Index" doc)
                                 "</refname>"
                                 "<refpurpose>Clickable index of all symbols</refpurpose>"
                                 "</refnamediv>"
                                 (eol))
                            (dolist (i content)
                              (unless (is-empty? i)
                                (present-object i doc :index)))
                            (put doc "</refentry>" (eol))))
        (put doc "</reference>" (eol))))))



(defmethod present-object
           ((obj sdoc-toplevel) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-tpl/docbook obj doc context)))

(defun get-file-extension-file-extension/docbook (doc)
  "returns a file-extension"
  nil
  (block get-file-extension ".xml"))



(defmethod get-file-extension
           ((doc docbook-document))
           (let ((?doc doc))
             (get-file-extension-file-extension/docbook doc)))

(defun print-header-package-header/docbook (obj doc context)
  "Prints a package header for docbook."
  (rule-notify-start :package-header/docbook)
  (block print-header
    (let* ((cl-name (get-object-name obj))
           (title (strcat cl-name " package"))
           (purpose "Exports/uses/nicknames/etc")
           (inherit-list (tl-get-fields "use" obj))
           (export-list (nreverse (tl-get-fields "export" obj)))
           (desc
            (let ((fields (tl-get-fields "documentation" obj)))
              (if fields (car fields) nil)))
           (tname "package")
           (tupname "Package")
           (no-desc nil))
      (put doc "<reference id=\"" (make-obj-id doc obj ?parent) "\">" (eol))
      (put doc "  <title>" tupname " " cl-name "</title>" (eol))
      (put doc
           " <refentry id=\"package"
           +id-word-delim+
           "content"
           +id-word-delim+
           (make-valid-entity cl-name)
           "\">"
           (eol))
      (tree-put doc
                `(:refmeta ,nil (:refentrytitle ,nil ,title) (:manvolnum nil 3)
                  (:refmiscinfo nil "Project name")))
      (tree-put doc
                `(:refnamediv ,nil (:refname ,nil ,title)
                  (:refpurpose ,nil ,(if purpose purpose ""))))
      (unless no-desc
        (tree-put doc
                  (list :refsect1
                        nil
                        (list :title nil "Description")
                        (list :para
                              nil
                              (if desc
                                  desc
                                  "[No description in DEFPACKAGE]")))))
      (when export-list
        (put doc "<refsect1>" (eol))
        (put doc " <title>" (get-word "Exports" doc) "</title>" (eol))
        (setf export-list (sort export-list #'string<))
        (cond
         ((> (length export-list) 3)
          (db-print-table doc export-list :columns 2))
         (t
          (tree-put doc
                    `(:simpara ,nil
                      ,(list-to-sep-string export-list
                                           :and-word
                                           (get-word "and" doc))))))
        (put doc "</refsect1>" (eol)))
      (when inherit-list
        (setf inherit-list
                (mapcar
                 #'(lambda (x)
                     (let ((lookup
                            (recursively-lookup-name (get-sdoc-toplevel)
                                                     x
                                                     :package)))
                       (cond
                        ((consp lookup)
                         (make-obj-link doc (car lookup) nil :desc x))
                        (t (apispec-xml:xmlify-string x)))))
                 inherit-list))
        (put doc "<refsect1>" (eol))
        (put doc " <title>" (get-word "Uses" doc) "</title>" (eol))
        (cond
         ((> (length inherit-list) 6)
          (db-print-table doc inherit-list :columns 2 :xmlify nil))
         (t
          (tree-put doc
                    `(:simpara ,nil
                      ,(list-to-sep-string inherit-list
                                           :and-word
                                           (get-word "and" doc))))))
        (put doc "</refsect1>" (eol)))
      (unless (has-spres-flag? :simple-package)
        (put doc "</refentry>" (eol))))))



(defmethod print-header
           ((obj t) (doc docbook-document) (context (eql :package)))
           (let ((?obj obj) (?doc doc) (?context context))
             (print-header-package-header/docbook obj doc context)))

(defun present-object-full-module/docbook (obj doc context)
  "Presents a module."
  (rule-notify-start :full-module/docbook)
  (block present-object
    (print-header obj doc :package)
    (let ((cl-name (get-object-name obj))
          (content-list (slot-value obj 'content)))
      (when content-list
        (let ((?rec-state :reference) (?parent obj))
          (dolist (i content-list) (present-object i doc context))))
      (put doc "</reference>" (eol)))))



(defmethod present-object
           ((obj sdoc-module) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-module/docbook obj doc context)))

(defun present-object-full-generic-package/docbook (obj doc context)
  "Presents lisp-specifics for a package."
  (rule-notify-start :full-generic-package/docbook)
  (block present-object
    (let ((*enclosing-package* obj)
          (*package-exports* (get-export-table obj))
          (*scope-stack* (cons obj *scope-stack*)))
      (multiple-value-bind
          (normal-objs individual-files)
          (filter-away (slot-value obj 'content)
                       #'(lambda (x) (should-have-individual-file-p x nil)))
        (when (albert-setting '("albert" "presentation" "only-exported"))
          (setf normal-objs
                  (filter
                   #'(lambda (obj)
                       (when (is-exported? obj (get-object-name obj)) obj))
                   normal-objs)))
        (let* ((cl-name (get-object-name obj))
               (?list-style :clever-sort)
               (var-count
                (loop for
                      x
                      in
                      normal-objs
                      when
                      (typep x 'sdoc-variable)
                      summing
                      1))
               (other-count (- (length normal-objs) var-count))
               (simple-package t))
          (when individual-files (setf simple-package nil))
          (when
              (>= var-count
                  (albert-setting
                   '("albert" "presentation" "variables" "separatepage")))
            (setf simple-package nil))
          (when simple-package (add-spres-flag! :simple-package))
          (print-header obj doc :package)
          (let ((?rec-state :reference) (?parent obj))
            (let ((meths 'nil) (others 'nil))
              (dolist (i individual-files)
                (if (typep i 'sdoc-method) (push i meths) (push i others)))
              (dolist (i (tl-sort-by-name others))
                (present-object i doc context))
              (dolist (i (tl-sort-by-name meths))
                (present-object i doc context))))
          (when normal-objs
            (let* ((cl-name (get-object-name obj))
                   (file-id
                    (strcat "package"
                            +id-word-delim+
                            "contentlist"
                            +id-word-delim+
                            (make-valid-entity cl-name)))
                   (fname
                    (strcat (make-valid-entity cl-name) "/" "contentlist"))
                   (?rec-state :refsect1)
                   (?parent obj)
                   (obj-count (length normal-objs))
                   (var-objs 'nil))
              (register-separate-document
               (make-file-info :id file-id :dir nil :fname fname))
              (with-ok-document (doc fname doc)
                                (when
                                    (>= var-count
                                        (albert-setting
                                         '("albert" "presentation" "variables"
                                           "separatepage")))
                                  (let ((vars 'nil) (others 'nil))
                                    (loop for
                                          i
                                          in
                                          normal-objs
                                          do
                                          (cond
                                           ((typep i 'sdoc-variable)
                                            (push i vars))
                                           ((typep i 'sdoc-method)
                                            (push i others))
                                           (t
                                            (when-verbose
                                             (albert-info
                                              "Non-method/var content ~s in package ~s"
                                              i
                                              cl-name))
                                            (push i others))))
                                    (setf var-objs
                                            (reverse vars)
                                          normal-objs
                                            (reverse others))))
                                (cond
                                 ((has-spres-flag? :simple-package)
                                  (present-objs-in-package doc
                                                           obj
                                                           normal-objs
                                                           :general
                                                           :refsect1)
                                  (present-objs-in-package doc
                                                           obj
                                                           var-objs
                                                           :vars
                                                           :refsect1))
                                 (var-objs
                                  (put doc
                                       "   <refentry id=\"packageX"
                                       (make-valid-entity cl-name)
                                       "Xvariables\">"
                                       (eol))
                                  (put doc
                                       "<refnamediv>"
                                       (eol)
                                       "<refname>"
                                       cl-name
                                       " variables</refname>"
                                       (eol)
                                       "<refpurpose>All variables and constants</refpurpose>"
                                       "</refnamediv>"
                                       (eol))
                                  (present-objs-in-package doc
                                                           obj
                                                           var-objs
                                                           :vars
                                                           :refsect1)
                                  (put doc " </refentry>" (eol))
                                  (put doc
                                       "   <refentry id=\"packageX"
                                       (make-valid-entity cl-name)
                                       "Xcontent\">"
                                       (eol))
                                  (put doc
                                       "<refnamediv>"
                                       (eol)
                                       "<refname>"
                                       cl-name
                                       " full listing</refname>"
                                       (eol)
                                       "<refpurpose>"
                                       "All funcallable objects"
                                       "</refpurpose>"
                                       "</refnamediv>"
                                       (eol))
                                  (present-objs-in-package doc
                                                           obj
                                                           normal-objs
                                                           :general
                                                           :refsect1)
                                  (put doc " </refentry>" (eol)))
                                 (t
                                  (put doc
                                       "   <refentry id=\"packageX"
                                       (make-valid-entity cl-name)
                                       "Xcontent\">"
                                       (eol))
                                  (put doc
                                       "<refnamediv>"
                                       (eol)
                                       "<refname>"
                                       cl-name
                                       " full listing</refname>"
                                       (eol)
                                       "<refpurpose>All funcallable objects and all variables</refpurpose>"
                                       "</refnamediv>"
                                       (eol))
                                  (present-objs-in-package doc
                                                           obj
                                                           normal-objs
                                                           :general
                                                           :refsect1)
                                  (present-objs-in-package doc
                                                           obj
                                                           var-objs
                                                           :vars
                                                           :refsect1)
                                  (put doc " </refentry>" (eol)))))))
          (when (has-spres-flag? :simple-package)
            (put doc "</refentry>" (eol))
            (remove-spres-flag! :simple-package))
          (put doc "</reference>" (eol)))))))



(defmethod present-object
           ((obj sdoc-package) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-generic-package/docbook obj doc context)))

(defun present-object-full-class/docbook (obj doc context)
  "Presents a full class."
  nil
  (block present-object
    (assert (eq ?rec-state :reference))
    (let ((*scope-stack* (cons obj *scope-stack*)))
      (multiple-value-bind
          (content-list individual-files)
          (filter-away (slot-value obj 'content)
                       #'(lambda (x) (should-have-individual-file-p x nil)))
        (with-ok-obj-document (doc obj doc)
                              (let ((cl-name (get-object-name obj))
                                    (print-class-details t)
                                    (quickindex-num
                                     (setting-or-default
                                      '("albert" "presentation" "class"
                                        "quickindex")
                                      7)))
                                (put doc
                                     "<refentry class=\"defclass\" id=\""
                                     (make-obj-id doc obj ?parent)
                                     "\">"
                                     (eol))
                                (when-bind
                                 (page-title (docbook-page-title doc obj))
                                 (when
                                     (and (stringp page-title)
                                          (plusp (length page-title)))
                                   (put doc
                                        " <refmeta><refentrytitle>"
                                        page-title
                                        "</refentrytitle></refmeta>"
                                        (eol))))
                                (put doc
                                     " <refnamediv>"
                                     (eol)
                                     "  <refname>"
                                     cl-name
                                     "</refname>"
                                     (eol))
                                (print-purpose obj doc context)
                                (put doc " </refnamediv>" (eol))
                                (when-bind (doc-list (sdoc-class.doc obj))
                                           (dolist (i doc-list)
                                             (let ((type (slot-value i 'type))
                                                   (text (slot-value i 'text)))
                                               (when
                                                   (string-equal (first type)
                                                                 "desc")
                                                 (put doc
                                                      " <refsynopsisdiv>"
                                                      (eol)
                                                      "  <title class=\"contenttitle\">"
                                                      (get-word "Description"
                                                                doc)
                                                      "</title>"
                                                      (eol)
                                                      "  <simpara>"
                                                      (first text)
                                                      "</simpara>"
                                                      (eol)
                                                      " </refsynopsisdiv>"
                                                      (eol))))))
                                (when (>= (length content-list) quickindex-num)
                                  (put doc
                                       " <refsect1>"
                                       (eol)
                                       "  <title class=\"contenttitle\">"
                                       (get-word "Quick-index" doc)
                                       "</title>"
                                       (eol))
                                  (let* ((?parent obj))
                                    (db-insert-index doc
                                                     content-list
                                                     4
                                                     :only-link-existing
                                                     nil))
                                  (put doc " </refsect1>" (eol)))
                                (when print-class-details
                                  (db-present-class-details doc obj))
                                (add-spres-flag! :dont-print-location)
                                (let* ((?parent obj))
                                  (present-with-content-manager obj
                                                                doc
                                                                content-list))
                                (remove-spres-flag! :dont-print-location)
                                (when
                                    (albert-setting
                                     '("albert" "presentation" "class"
                                       "related-methods"))
                                  (let* ((related (find-related-methods obj))
                                         (result
                                          (set-difference related
                                                          (slot-value obj
                                                                      'content)
                                                          :test
                                                          #'equal
                                                          :key
                                                          #'get-object-name)))
                                    (when result
                                      (add-spres-flag! :related-methods)
                                      (add-spres-flag! :dont-print-anchor)
                                      (let* ((?parent obj))
                                        (present-with-content-manager obj
                                                                      doc
                                                                      result))
                                      (remove-spres-flag! :related-methods)
                                      (remove-spres-flag!
                                       :dont-print-anchor))))
                                (put doc "</refentry>" (eol))))
        (when individual-files
          (let ((?parent obj))
            (dolist (i individual-files) (present-object i doc context))))))))



(defmethod present-object
           ((obj sdoc-class) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-class/docbook obj doc context)))

(defun print-purpose-generic-class-purpose (obj doc context)
  nil
  nil
  (block print-purpose
    (let ((purpose ""))
      (when-bind (doc-list (slot-value obj 'doc))
                 (dolist (i doc-list)
                   (let ((type (slot-value i 'type))
                         (text (slot-value i 'text)))
                     (when (string-equal (first type) "purpose")
                       (setf purpose (first text))))))
      (unless (plusp (length purpose))
        (let ((inh
               (list-to-sep-string
                (mapcar #'tl-make-link-for-class (get-inherit-obj obj))
                :and-word
                (get-word "and" doc))))
          (cond
           ((tl-is-struct? obj)
            (setf purpose
                    (albert-setting
                     '("albert" "presentation" "default-purpose-string"
                       "struct"))))
           (t
            (setf purpose
                    (albert-setting
                     '("albert" "presentation" "default-purpose-string"
                       "class")))))
          (when (plusp (length inh))
            (setf purpose (strcat purpose " inheriting " inh)))))
      (when (eq purpose nil) (setf purpose ""))
      (put doc
           "  <refpurpose class=\"contenttitle\">"
           purpose
           "</refpurpose>"
           (eol)))))



(defmethod print-purpose
           ((obj sdoc-class) (doc docbook-document) (context t))
           (let ((?obj obj) (?doc doc) (?context context))
             (print-purpose-generic-class-purpose obj doc context)))

(defun print-purpose-generic-fun-purpose (obj doc context)
  nil
  nil
  (block print-purpose
    (let ((purpose ""))
      (let ((fields (tl-get-fields "purpose" obj)))
        (when fields (warn ">> Purpose ~a" fields)))
      (unless (plusp (length purpose))
        (cond
         ((is-generic-fun? obj)
          (setf purpose
                  (albert-setting
                   '("albert" "presentation" "default-purpose-string"
                     "generic"))))
         (t
          (setf purpose
                  (albert-setting
                   '("albert" "presentation" "default-purpose-string"
                     "method"))))))
      (when (eq purpose nil) (setf purpose ""))
      (put doc "  <refpurpose>" purpose "</refpurpose>" (eol)))))



(defmethod print-purpose
           ((obj sdoc-method) (doc docbook-document) (context t))
           (let ((?obj obj) (?doc doc) (?context context))
             (print-purpose-generic-fun-purpose obj doc context)))

(defun present-object-full-method/docbook (obj doc context)
  "Presents a full method."
  nil
  (block present-object
    (let ((meth-name (get-object-name obj)) (exportclass ""))
      (unless meth-name (setq meth-name "{not-named}"))
      (when (is-exported? obj meth-name)
        (setf exportclass " class=\"exported\""))
      (put doc
           "<formalpara"
           exportclass
           ">"
           (eol)
           "<title>"
           (if
            (or (has-spres-flag? :in-gf) (has-spres-flag? :dont-print-anchor))
            ""
            (get-simple-anchor doc
                               (make-obj-id doc
                                            obj
                                            ?parent
                                            :allow-cached
                                            nil)))
           (cond
            ((has-spres-flag? :related-methods)
             (let ((up-package (get-enclosing-package obj)))
               (if up-package
                   (concatenate 'string (get-object-name up-package) ":")
                   "")))
            (t ""))
           meth-name
           "</title>"
           (eol))
      (put doc "<para>" (eol))
      (let* ((the-obj obj)
             (doc-list (sdoc-method.doc the-obj))
             (loc-list nil)
             (show-loc nil)
             (not-wanted (list "mod" "class" "dispatch" "language"))
             (info-list nil))
        (when-bind (where (slot-value obj 'where))
                   (setf loc-list
                           (flatten
                            (loop for
                                  x
                                  in
                                  where
                                  collecting
                                  (slot-value x 'location)))))
        (when
            (and loc-list
                 (tl-show-location? :variable)
                 (not (has-spres-flag? :dont-print-location)))
          (setf show-loc t))
        (unless
            (albert-setting '("albert" "presentation" "funcallable" "calls"))
          (push "calls" not-wanted))
        (unless
            (albert-setting
             '("albert" "presentation" "funcallable" "calledby"))
          (push "calledby" not-wanted))
        (setf info-list
                (get-info-except-types (sdoc-method.info obj) not-wanted))
        (put doc
             "<programlisting>"
             (apispec-xml:xmlify-string
              (get-method-signature doc the-obj :linked nil :style :intuitive))
             "</programlisting>"
             (eol))
        (when (or doc-list info-list)
          (put doc "<variablelist>" (eol))
          (db-present-doc-list doc-list doc :method :suppress-wrapper t)
          (db-present-info-list info-list doc :method :suppress-wrapper t)
          (when show-loc
            (setf loc-list (mapcar #'possibly-cvs-link loc-list))
            (db-print-location loc-list doc :variable :suppress-wrapper t))
          (put doc "</variablelist>" (eol))))
      (put doc "</para></formalpara>" (eol)))
    (when-bind (content (sdoc-method.content obj))
               (add-spres-flag! :in-gf)
               (dolist (i content) (present-object i doc ?context))
               (remove-spres-flag! :in-gf))))

(defun present-object-full-tpl-method/docbook (obj doc context)
  "Presents a full GF."
  nil
  (block present-object
    (with-ok-obj-document (doc obj doc)
                          (let ((cl-name (get-object-name obj))
                                (print-class-details t))
                            (put doc
                                 "<refentry id=\""
                                 (make-obj-id doc obj ?parent)
                                 "\">"
                                 (eol))
                            (put doc
                                 "<refnamediv>"
                                 (eol)
                                 "<refname>"
                                 cl-name
                                 "</refname>"
                                 (eol))
                            (print-purpose obj doc context)
                            (put doc "</refnamediv>" (eol))
                            (when-bind (doc-list (sdoc-method.doc obj))
                                       (dolist (i doc-list)
                                         (let ((type (slot-value i 'type))
                                               (text (slot-value i 'text)))
                                           (cond
                                            ((equal "desc" (first type))
                                             (put doc
                                                  " <refsynopsisdiv>"
                                                  (eol)
                                                  "  <title class=\"contenttitle\">"
                                                  (get-word "Description" doc)
                                                  "</title>"
                                                  (eol)
                                                  "  <simpara>"
                                                  (apispec-xml:xmlify-string
                                                   (first text))
                                                  "</simpara>"
                                                  (eol)
                                                  " </refsynopsisdiv>"
                                                  (eol)))
                                            (t
                                             (warn
                                              "Albert: Unknown GF docs ~s ~s ~s"
                                              cl-name
                                              type
                                              text))))))
                            (add-spres-flag! :in-gf)
                            (let* ((?parent obj))
                              (present-with-content-manager obj
                                                            doc
                                                            (slot-value obj
                                                                        'content)))
                            (remove-spres-flag! :in-gf)
                            (put doc "</refentry>" (eol))))))



(defmethod present-object
           ((obj sdoc-method) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (cond
              ((and (or (eq ?rec-state :refsect1) (eq ?rec-state :refsect2)))
               (present-object-full-method/docbook obj doc context))
              ((and (eq ?rec-state :reference))
               (present-object-full-tpl-method/docbook obj doc context))
              (t
               (error "Fell through ~s and obj is ~s" 'present-object ?obj)))))

(defun present-object-full-variable/docbook (obj doc context)
  "Presents a full variable."
  nil
  (block present-object
    (unless (or (eq ?rec-state :refsect1) (eq ?rec-state :refsect2))
      (warn "Weird recstate for variable: ~s" ?rec-state)
      (return-from present-object nil))
    (let* ((obj-name (get-object-name obj))
           (doc-list (slot-value obj 'doc))
           (not-wanted (list "mod" "type"))
           (info-list
            (get-info-except-types (slot-value obj 'info) not-wanted))
           (loc-list (slot-value obj 'location))
           (show-loc (and loc-list (tl-show-location? :variable)))
           (formal-pres nil)
           (exportclass "")
           (experiment t))
      (when (or doc-list info-list) (setf formal-pres t))
      (when (and show-loc (not (has-spres-flag? :dont-print-location)))
        (setf formal-pres t))
      (when (is-exported? obj obj-name)
        (setf exportclass " class=\"exported\""))
      (when (or formal-pres experiment)
        (unless obj-name (setq obj-name "{not named}"))
        (put doc
             " <formalpara"
             exportclass
             ">"
             (eol)
             "  <title>"
             (get-simple-anchor doc (make-obj-id doc obj ?parent))
             obj-name
             "  </title>"
             (eol)))
      (put doc "  <para>" (eol))
      (tree-put doc
                `(:programlisting ,nil
                  ,(get-variable-signature doc
                                           obj
                                           :linked
                                           nil
                                           :style
                                           :intuitive)))
      (when formal-pres
        (put doc "   <variablelist>" (eol) "    <title></title>" (eol))
        (db-present-doc-list doc-list doc :variable :suppress-wrapper t)
        (unless (has-spres-flag? :dont-print-location)
          (db-print-location loc-list doc :variable :suppress-wrapper t))
        (db-present-info-list info-list doc :variable :suppress-wrapper t)
        (put doc "   </variablelist>" (eol)))
      (put doc "  </para>" (eol))
      (when (or formal-pres experiment) (put doc " </formalpara>" (eol))))))



(defmethod present-object
           ((obj sdoc-variable) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-variable/docbook obj doc context)))

(defun present-object-full-typespec/docbook (obj doc context)
  "Presents a full typespec."
  nil
  (block present-object
    (unless (eq ?rec-state :refsect1) (return-from present-object nil))
    (let* ((obj-name (get-object-name obj))
           (doc-list (slot-value obj 'doc))
           (not-wanted (list "mod" "type"))
           (info-list
            (get-info-except-types (slot-value obj 'info) not-wanted))
           (loc-list (slot-value obj 'location))
           (show-loc (and loc-list (tl-show-location? :variable)))
           (formal-pres (or doc-list info-list show-loc)))
      (when formal-pres
        (unless obj-name (setq obj-name "{not named}"))
        (put doc
             "<formalpara>"
             (eol)
             "<title>"
             (get-simple-anchor doc (make-obj-id doc obj ?parent))
             obj-name
             "</title>"
             (eol)))
      (put doc "<para>" (eol))
      (tree-put doc `(:programlisting ,nil ,(strcat "typespec " obj-name)))
      (when formal-pres
        (put doc "<variablelist>" (eol))
        (db-present-doc-list doc-list doc :variable :suppress-wrapper t)
        (db-print-location loc-list doc :variable :suppress-wrapper t)
        (db-present-info-list info-list doc :variable :suppress-wrapper t)
        (put doc "</variablelist>" (eol)))
      (put doc "</para>" (eol))
      (when formal-pres (put doc "</formalpara>" (eol))))))



(defmethod present-object
           ((obj sdoc-typespec) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-typespec/docbook obj doc context)))

(defun present-object-full-enum/docbook (obj doc context)
  "Presents a full enum."
  nil
  (block present-object
    (unless (eq ?rec-state :refsect1) (return-from present-object nil))
    (let* ((obj-name (get-object-name obj))
           (doc-list (slot-value obj 'doc))
           (loc-list (slot-value obj 'location))
           (show-loc (and loc-list (tl-show-location? :variable)))
           (formal-pres nil))
      (when formal-pres
        (unless obj-name (setq obj-name "{not named}"))
        (put doc
             "<formalpara>"
             (eol)
             "<title>"
             (get-simple-anchor doc (make-obj-id doc obj ?parent))
             obj-name
             "</title>"
             (eol)))
      (put doc "<para>" (eol))
      (tree-put doc `(:programlisting ,nil ,(strcat "enum " obj-name)))
      (when formal-pres
        (put doc "<variablelist>" (eol))
        (db-present-doc-list doc-list doc :variable :suppress-wrapper t)
        (db-print-location loc-list doc :variable :suppress-wrapper t)
        (put doc "</variablelist>" (eol)))
      (put doc "</para>" (eol))
      (when formal-pres (put doc "</formalpara>" (eol))))))



(defmethod present-object
           ((obj sdoc-enum) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-enum/docbook obj doc context)))

(defun present-object-full-category/docbook (obj doc context)
  "Presents a full category."
  nil
  (block present-object
    (let ((meth-name (get-object-name obj))
          (the-type (get-string sdoc-category.type obj))
          (the-parent ?parent)
          (content-list (slot-value obj 'content)))
      (unless meth-name (setq meth-name "{not-named}"))
      (cond
       ((equal the-type "method")
        (let ((first-obj (first content-list)))
          (put doc
               "<formalpara>"
               (eol)
               "<title>"
               (cond
                ((has-spres-flag? :related-methods)
                 (let ((up-package (get-enclosing-package obj)))
                   (if up-package
                       (concatenate 'string (get-object-name up-package) ":")
                       "")))
                (t ""))
               meth-name
               "</title>"
               (eol))))
       ((equal the-type "variable"))
       ((equal the-type "userspec") (error "USER-spec cats, not working yet"))
       (t (warn "Fell through category-type with ~s." the-type)))
      (put doc "<para>" (eol))
      (unless (has-spres-flag? :dont-print-anchor)
        (when (or (equal the-type "variable") (equal the-type "method"))
          (let ((good-ids
                 (remove-duplicates
                  (loop for
                        i
                        in
                        content-list
                        collecting
                        (make-obj-id doc i the-parent))
                  :test
                  #'equal)))
            (dolist (i good-ids) (put doc (get-simple-anchor doc i))))))
      (put doc "<programlisting>")
      (dolist (i content-list)
        (etypecase i
          (sdoc-method
           (put doc
                (apispec-xml:xmlify-string
                 (get-method-signature doc i :linked nil :style :intuitive))
                (eol)))
          (sdoc-variable
           (let ((exported? (is-exported? i (get-object-name i))))
             (if exported?
                 (put doc "<property role=\"exported\">")
                 (put doc "<property role=\"internal\">"))
             (put doc
                  (apispec-xml:xmlify-string
                   (get-variable-signature doc
                                           i
                                           :linked
                                           nil
                                           :style
                                           :intuitive)))
             (put doc "</property>")
             (put doc (eol))))))
      (put doc "</programlisting>" (eol))
      (put doc "</para>" (eol))
      (when (or (equal the-type "method") (equal the-type "userspec"))
        (put doc "</formalpara>" (eol))))))



(defmethod present-object
           ((obj sdoc-category) (doc docbook-document) (context (eql :full)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-full-category/docbook obj doc context)))

(defun print-content-list-clever-sort-of-content-presenter
       (obj doc content-list)
  "A positively evil way to sort content."
  nil
  (block print-content-list
    (multiple-value-bind
        (normal-objs individual-files)
        (filter-away content-list
                     #'(lambda (x) (should-have-individual-file-p x nil)))
      (when individual-files
        (error "Have got individual file ~s, this should be fixed elsewhere"
               individual-files))
      (let ((buckets
             (tl-divide-and-order-objects normal-objs ?prog-lang :also-sort t)))
        (let ((merged-buckets
               (loop for
                     x
                     in
                     buckets
                     collecting
                     (when x (tl-merge-list doc x))))
              (next-state (tl-get-next-section-state ?rec-state)))
          (dolist (i merged-buckets)
            (when (and i (car i))
              (put doc
                   "<"
                   (cdr next-state)
                   ">"
                   (eol)
                   "<title class=\"contenttitle\">"
                   (get-word (tl-get-sect-heading-from-type (car i)) doc)
                   "</title>"
                   (eol))
              (let ((?rec-state (car next-state)))
                (dolist (x i)
                  (assert (eq nil (should-have-individual-file-p x nil)))
                  (present-object x doc ?context)))
              (put doc "</" (cdr next-state) ">" (eol)))))))))



(defmethod print-content-list
           ((obj t) (doc t) (content-list t))
           (let ((?obj obj) (?doc doc))
             (cond
              ((and (eq ?list-style :clever-sort))
               (print-content-list-clever-sort-of-content-presenter obj doc
                content-list))
              (t
               (warn "Fell through ~s and obj is ~s"
                     'print-content-list
                     ?obj)))))

(defun present-object-pck-idx/docbook (obj doc context)
  "index a package"
  (rule-notify-start :pck-idx/docbook)
  (block present-object
    (let ((content (slot-value obj 'content)))
      (put doc
           "<refsect1><title>Index for package "
           (get-object-name obj)
           "</title>"
           (eol))
      (let* ((?parent obj))
        (db-insert-index doc
                         content
                         (if (is-prog-lang? :lisp) 2 3)
                         :only-link-existing
                         nil))
      (put doc "</refsect1>" (eol)))))



(defmethod present-object
           ((obj sdoc-package) (doc docbook-document) (context (eql :index)))
           (let ((?obj obj) (?doc doc) (?context context))
             (present-object-pck-idx/docbook obj doc context)))
