<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.1">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Creates an HTML coverpage for the album -->
<xsl:template match="album" mode="coverpage">
<xsl:document method="html" indent="yes" href="{concat($outputPath, '/Album.html')}"> 
<html>
  <head>
    <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
    <style type="text/html">
      &lt;!--
      A{text-decoration:none}
      --&gt;
    </style>
    <style type="text/css">
      &lt;!--
      h3 {font-size: 12pt; font-weight: bold; text-align: center}
      h4 {font-size: 10pt; font-weight: normal; text-align: center}
      h4.ital {font-size: 10pt; font-weight: normal; text-align: center}
      --&gt;
    </style>
    <title><xsl:value-of select="name"/></title>
  </head>
  <body>
    <xsl:if test="thumb">
      <xsl:variable name="albumThumbnail" select="thumb/@path"/>
      <center>       
        <img src="{$albumThumbnail}" alt="Representative Album Image"/>
      </center>
    </xsl:if>
    <center>
      <table>
        <tr>
          <td width="426">
            <h3>
              <xsl:value-of select="name"/>
            </h3>
            <h4>
              <xsl:value-of select="description"/>
            </h4>
          </td>
        </tr>
      </table>
    </center>
    <center>
      <table border="0">
        <tr>
        <xsl:for-each select="subalbum">
          <td valign="top" width="220" align="center">
            <table border="0">
              <tr>
                <td valign="top" align="center">
                  <xsl:if test="thumb">
                    <xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
                    <center>
                      <script type="text/javascript" language="JavaScript">
                        <![CDATA[
                        <!-- HIDE FROM OLD BROWSERS
                        ]]>
                        
                        <xsl:if test="count(photo)">
                        <![CDATA[                                              
                        document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
                        ]]>
                        </xsl:if>
                        
                        <![CDATA[                                              
                        document.write("  <img alt=\"Subalbum ]]><xsl:value-of select="position()"/><![CDATA[\" src=\"]]><xsl:value-of select="$subalbumThumbnail"/><![CDATA[\"/>")
                        ]]>
                        
                        <xsl:if test="count(photo)">
                        <![CDATA[                                                                      
                        document.write("</a>")
                        ]]>
                        </xsl:if>
                        
                        <![CDATA[                                                                                            
                        -->
                        ]]>
                      </script>
                      <noscript>
                        
                        <xsl:if test="count(photo)">                       
                      <![CDATA[
                          <a href="subalbum_{position()}_thumbs.html">
                      ]]>
                        </xsl:if>
                          
                          <img src="{$subalbumThumbnail}"/>
                        <xsl:if test="count(photo)">
                      <![CDATA[
                          </a>
                      ]]>
                        </xsl:if>
                      
                      </noscript>
                    </center>
                  </xsl:if>
                </td>
              </tr>
              <tr>
                <td valign="bottom" align="center">
                  <center>
                    <script type="text/javascript" language="JavaScript">
                      <![CDATA[
                      <!-- HIDE FROM OLD BROWSERS
                        ]]>
                                      
                      <xsl:if test="count(photo)">                       
                        <![CDATA[                                                                      
                        document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
                        ]]>
                     </xsl:if>
                      
                      <![CDATA[                                                                      
                      document.write("  ]]><xsl:value-of select="name"/><![CDATA[")
                      ]]>
                        
                      <xsl:if test="count(photo)">                       
                        <![CDATA[                                                                      
                        document.write("</a>")
                        ]]>
                     </xsl:if>                  
                      
                      <![CDATA[                                                                      
                      -->
                      ]]>
                    </script>
                    <noscript>
                      
                      <xsl:if test="count(photo)">                                                                 
                      <![CDATA[                                                                      
                        <a href="subalbum_{position()}_thumbs.html">
                      ]]>
                      </xsl:if>
                        
                      <xsl:value-of select="name"/>
                      
                      <xsl:if test="count(photo)">                                                                 
                      <![CDATA[                                                                      
                        </a>
                      ]]>
                      </xsl:if>                
                    
                    </noscript>
                  </center>
                </td>
              </tr>
            </table>
          </td>
          <xsl:if test="not(position() mod 3)">
            <xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr&gt;</xsl:text>
          </xsl:if>
        </xsl:for-each>
        <xsl:call-template name="endRow">
          <xsl:with-param name="cellsLeft" select="(3 - (count(subalbum) mod 3))"/>
        </xsl:call-template>
        </tr>
      </table>
    </center>
    <h4 class="ital">
      <xsl:variable name="Cyear" select="substring-before(created, ' ')"/>
      <xsl:variable name="Cmonth" select="substring-before( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Cday" select="substring-after( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Myear" select="substring-before(modified, ' ')"/>
      <xsl:variable name="Mmonth" select="substring-before( substring-after(modified, ' '), ' ')"/>
      <xsl:variable name="Mday" select="substring-after( substring-after(modified, ' '), ' ')"/>
      (Album created on <xsl:value-of select="$Cmonth"/>/<xsl:value-of select="$Cday"/>/<xsl:value-of select="$Cyear"/>, 
       last modified on <xsl:value-of select="$Mmonth"/>/<xsl:value-of select="$Mday"/>/<xsl:value-of select="$Myear"/>, 
       for <xsl:value-of select="author"/> by
       <a href="http://albumshaper.sourceforge.net">Album Shaper</a>, Classic theme)
    </h4>
  </body>
</html>
</xsl:document>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
