//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qlayout.h>
#include <qlabel.h>
#include <qfont.h>
#include <qframe.h>
#include <qcheckbox.h>
#include <qvgroupbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qslider.h>
#include <qvalidator.h>

//Projectwide includes
#include "loadingSavingWidget.h"
#include "configuration.h"
#include "../config.h"

//PLATFORM_SPECIFIC_CODE
#if defined(Q_OS_WIN)
#include <stdlib.h>
#endif

//==============================================
LoadingSavingWidget::LoadingSavingWidget( Configuration* config,
                                          QWidget* parent,
                                          const char* name ) : QWidget( parent, name)
{
  this->config = config;

  categoryLabel = new QLabel( tr("Loading + Saving:"), this);
  QFont labelFont = categoryLabel->font();
  labelFont.setWeight(QFont::Bold);
  categoryLabel->setFont( labelFont );

  horizontalLine = new QFrame(this);
  horizontalLine->setLineWidth(2);
  horizontalLine->setMidLineWidth(1);
  horizontalLine->setFrameStyle( QFrame::HLine | QFrame::Raised );
  //----------------
  //Default new album theme
  defaultToThisThemeFrame = new QFrame( this );
  defaultToThisThemeOnNew = new QLabel( tr("Default new album theme:"), defaultToThisThemeFrame);
  defaultToThisTheme = new QComboBox( defaultToThisThemeFrame );
  
  defaultToThisTheme->insertItem( tr("Last Used") );
  QDir localDir( THEMES_PATH );
  QStringList list = localDir.entryList( QDir::Dirs );
  QStringList::Iterator file;
  for ( file = list.begin(); file != list.end(); ++file )
  {
    if(localDir.exists( QString(*file) + "/theme.xsl" ))
      defaultToThisTheme->insertItem( *file );
  }
  
  defaultToThisThemeGrid = new QGridLayout(defaultToThisThemeFrame, 1, 4, 0);
  defaultToThisThemeGrid->addWidget(defaultToThisThemeOnNew, 0, 0);
  defaultToThisThemeGrid->setColSpacing(1, 8);
  defaultToThisThemeGrid->addWidget(defaultToThisTheme, 0, 2);
  defaultToThisThemeGrid->setColSpacing(3, 8);
  defaultToThisThemeGrid->setColStretch(3, 1);
  //----------------
  //Temp directory
  tempImageDirectoryFrame = new QFrame( this );
  tempImageDirectory = new QLabel( tr("Temporary image directory:"), tempImageDirectoryFrame);
  tempImageDirectoryVal = new QLineEdit( tempImageDirectoryFrame );
  tempImageDirectoryVal->setText( "/home" );
  browseButton = new QPushButton( tempImageDirectoryFrame );
  browseButton->setPixmap( QPixmap(QString(IMAGE_PATH)+"buttonIcons/browse.png") );
  browseButton->setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Maximum );
  QToolTip::add( browseButton, tr("Browse to temporary image directory") );
  connect( browseButton, SIGNAL(clicked()), SLOT(browse()) );

  tempImageDirectoryGrid = new QGridLayout(tempImageDirectoryFrame, 1, 5, 0);
  tempImageDirectoryGrid->addWidget(tempImageDirectory, 0, 0);
  tempImageDirectoryGrid->setColSpacing(1, 8);
  tempImageDirectoryGrid->addWidget(tempImageDirectoryVal, 0, 2);
  tempImageDirectoryGrid->setColStretch(2, 1);
  tempImageDirectoryGrid->setColSpacing(3, 8);
  tempImageDirectoryGrid->addWidget(browseButton, 0, 4);
  //----------------
  //Check photo mods since last load?
  checkPhotoMods = new QCheckBox( tr("Check for photo modifications"), this );
  //----------------
  //Setup larger boxes in overall grid
  mainGrid = new QGridLayout( this, 6, 1, 0);  
  mainGrid->setSpacing( WIDGET_SPACING );
    
  mainGrid->addWidget( categoryLabel, 0, 0, Qt::AlignLeft );
  mainGrid->addWidget( horizontalLine, 1, 0 );
  mainGrid->addWidget( defaultToThisThemeFrame,  2, 0 );
  mainGrid->addWidget( tempImageDirectoryFrame,  3, 0 );
  mainGrid->addWidget( checkPhotoMods,  4, 0 );
  mainGrid->setRowStretch( 5, 1 );
  //----------------
}
//==============================================
void LoadingSavingWidget::browse()
{
  QString dirName = QFileDialog::getExistingDirectory( tempImageDirectoryVal->text(),
                                                                          this, NULL, "Temporary Image Directory");
  if(!dirName.isNull())
    tempImageDirectoryVal->setText( dirName );
}
//==============================================
void LoadingSavingWidget::setDefaults(Configuration* config)
{
  config->setBool( "loadSave", "disableCheckPhotoMods", true );
  config->setString( "loadSave", "defaultTheme", "Last Used" );
  config->setString( "loadSave", "lastUsedTheme", "Slick" );
  //-------
  //set default loading/saving albums, add photo, and temp image directories
  config->setString( "loadSave", "tempImageDirectory", TEMP_DIR );

  //PLATFORM_SPECIFIC_CODE

  //Mac OS X
  #if defined(Q_OS_MACX)
  config->setString( "loadSave", "loadSaveDir",  QDir::homeDirPath() + QString("/Pictures") );

  //Windows
  #elif defined(Q_OS_WIN)
  config->setString( "loadSave", "loadSaveDir",
                           QDir::convertSeparators( getenv("USERPROFILE") +
                                                    QString("/My Documents/My Pictures") ));

  //Unix/Linux/BSD
  #else
  config->setString( "loadSave", "loadSaveDir", QDir::homeDirPath() );
  #endif

  config->setString( "loadSave", "addPhotoDir", config->getString( "loadSave", "loadSaveDir") );
  //-------
  config->setBool( "loadSave", "useDefaultImageSizes", true );
  config->setInt( "loadSave", "thumbWidth", 200 );
  config->setInt( "loadSave", "thumbHeight", 150 );
  config->setInt( "loadSave", "slideshowWidth", 600 );
  config->setInt( "loadSave", "slideshowHeight", 400 );
  config->setInt( "loadSave", "albumWidth", 500 );
  config->setInt( "loadSave", "albumHeight", 320 );
  config->setInt( "loadSave", "subalbumWidth", 200 );
  config->setInt( "loadSave", "subalbumHeight", 150 );
}
//==============================================
void LoadingSavingWidget::loadSettings()
{
  checkPhotoMods->setChecked( ! config->getBool( "loadSave", "disableCheckPhotoMods" ));
  tempImageDirectoryVal->setText( config->getString( "loadSave", "tempImageDirectory" ) );
  tempImageDirectoryVal->setCursorPosition(0);

  int i;
  bool defaultTFound = false;
  QString defaultT = config->getString( "loadSave", "defaultTheme" );
  for(i=1; i<defaultToThisTheme->count(); i++)
  {
    defaultToThisTheme->setCurrentItem(i);
    if(defaultToThisTheme->currentText().compare( defaultT ) == 0)
    {
      defaultTFound = true;
      break;
    }
  }

  if(!defaultTFound)
    defaultToThisTheme->setCurrentItem(0);
}
//==============================================
void LoadingSavingWidget::saveSettings()
{
  config->setBool( "loadSave", "disableCheckPhotoMods", !checkPhotoMods->isChecked() );
  config->setString( "loadSave", "tempImageDirectory",
  QDir::convertSeparators( QDir::cleanDirPath( tempImageDirectoryVal->text() ) ) );
  config->setString( "loadSave", "defaultTheme", defaultToThisTheme->currentText() );
}
//==============================================
