//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef CONFIGURATION_SETTING_H
#define CONFIGURATION_SETTING_H

//--------------------
//forward declarations
class QString;
//--------------------

//=====================================
/*! \brief Setting class, allows the setting and retrieval of setting values
 */
//=====================================
class Setting
{
public:
  Setting(QString key, QString value);
  
  //returns the setting key
  QString getKey();
  
  //returns the value
  QString getValue();
  
  //sets the value
  void setValue(QString value);
  
  ///gets a pointer to the next setting in the list
  Setting* getNext();
  
  ///sets a pointer to the next setting in the list
  void setNext( Setting* next );

  ///resets value to default
  void resetSetting();
  
private:
  ///setting key/identifier
  QString key;
  
  ///vaue
  QString value;
  QString defaultValue;
  
  ///pointer to next setting in list
  Setting* next;;
};
//----------------------------------------------

#endif //CONFIGURATION_SETTING_H
