//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#include "blurSharpenSlider.h"

//==========================================
BlurSharpenSlider::BlurSharpenSlider( Orientation orientation, 
                                      QWidget* parent, const char* name )
                                    : DynamicSlider( orientation, parent, name) 
{
  setZeroString( tr("No change") );
  setPrefixes( QString(tr("Blur"))+": ", 
               QString(tr("Sharpen"))+": " );
  setSuffix("x");  
}
//==========================================
QString BlurSharpenSlider::mapValToString()
{
  //always use the absolute value of the value
  return QString("%1").arg( QABS(value()) );
}
//==========================================
