//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_DIALOGS_ALERTDIALOG_H
#define GUI_DIALOGS_ALERTDIALOG_H

//--------------------
//forward delcarations
class QGridLayout;
class QLabel;
class QTextEdit;
class QPushButton;
class QPixmap;
class QFrame;
//--------------------

#include <qdialog.h>

//=====================================
/*! \brief A configurable alert dialog that displays an alert/error message
 */
//=====================================

class AlertDialog : public QDialog
{
Q_OBJECT
//----------------------
public:
  ///Basic constructor
  AlertDialog( QString message,
                    QString description,
                    QString alertIconName,
                    QWidget *parent=0,
                    const char* name=0);

  ///Destructor
  ~AlertDialog();
//----------------------
private:
  ///Grids objects placed in
  QGridLayout *gridTop, *gridBottom, *gridFull;

  ///Message displayed in window
  QLabel* alertText;

  ///Description displayed in window
  QTextEdit* descriptionText;

  ///Ok button
  QPushButton* okButton;

  ///Alert icon
  QPixmap* alertIcon;

  ///Label which shows alert icon
  QLabel* alertIconLabel;

  ///Top and bottom frames
  QFrame *topFrame, *bottomFrame;
//----------------------
};
//======================

#endif //GUI_DIALOGS_ALERTDIALOG_H
