//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_EDITING_GRAINEDITOR_H
#define GUI_EDITING_GRAINEDITOR_H

//--------------------
//forward declarations
class BlurSharpenSlider;
class PanningPreviewInterface;
class SelectionPlacementInterface;
//--------------------
class QComboBox;
class QFrame;
class ClickableLabel;

#include <qdialog.h>
#include <qimage.h>

//=====================================
/*! \brief Interface for adjusting image grain by bluring and sharpening. */
//=====================================

class GrainEditor : public QDialog
{
Q_OBJECT

public:
  ///Constructs layout
  GrainEditor(QString filename,
                  QWidget *parent=0, const char* name=0);

  ~GrainEditor();
  
  ///get modified image that resulted from adjustments
  QImage* getModifiedImage();
  //----------------------
protected:
  void keyPressEvent(QKeyEvent *e);
  void keyReleaseEvent(QKeyEvent *e);
  //----------------------
private slots:
  ///updates preview image
  void selectPreviewImageType(int selection);

  ///reset blur/sharpen of object boundaries
  void resetBoundaries();

  ///reset blur/sharpen of regions
  void resetRegions();

  ///check for changes to settings, if so 
  //accepts changes, otherwise calls reject
  void applyAction();  

  ///resets image grain to original state
  void resetAction();

  ///handle resize preview signals
  void previewResized();

  ///generate and set adjusted image
  void generateAdjustedPreviewImage();
  
  //----------------------
private:
  //adjust image using current blur/sharpen setting
  void adjustImage( QImage& image, QPoint offset );
    
  //original image filename
  QString fileName;
  
  //original image size
  QSize origImageSize;
  
  //Edges image
  QImage edgesImage;
  
  //Cluster map - each pixel assigned an int for the cluster it belongs to
  int* clusterMap;
  int numRegions;
  
  ///Preview image
  PanningPreviewInterface* previewInterface;
      
  ///Interface for placing selection
  SelectionPlacementInterface* selectionPlacementInterface;
  
  QComboBox* previewSelection;
  QFrame* buttonsFrame;  
  
  ///Grain slider
  BlurSharpenSlider* boundariesSlider;
  ClickableLabel* boundariesIcon;

  BlurSharpenSlider* regionsSlider;
  ClickableLabel* regionsIcon;
};
//======================

#endif //GUI_EDITING_GRAINEDITOR_H
