
/*
	Ansicht-Men modifizieren
		=> Aufruf durch aios_initSidebar()
*/
function aios_modFFViewMenu() {
	var items = document.getElementsByAttribute('key', 'key_viewSource');

	for(var i = 0; i < items.length; i++) {
		if(items[i].parentNode.id == "menu_viewPopup") {
			items[i].setAttribute('onclick', 'aios_contextEvent(event, this);');
			items[i].setAttribute('class', 'menuitem-iconic');
		}

	}
}


/*
	modifiziert das Firefox-Sidebar-Men
		=> Aufruf durch aios_initSidebar() und aios_getSidebarMenu() (Menbutton-Events 'onpopupshowing')
*/
function aios_modSidebarMenu() {
	aios_getObjects();

  var actSidebar = aios_remLastSidebar();
  var command, commandParent;

	// jeden einzelnen Menpunkt bernehmen oder ggfs. abndern
  for(var i = 0; i < fx_sidebarMenu.childNodes.length; i++) {
  	command = null;
  	commandParent = null;
  	var broadcaster = null;
  	var item = fx_sidebarMenu.childNodes[i];

		// Icons ein- oder ausblenden
		try {
			var enable_icons = aios_gPrefBranch.getBoolPref('menus.sidebar.icons');
			var theClass = (enable_icons) ? '' : 'aios-noIcons';

			if(theClass != '') aios_appendClass(item, theClass);
			else aios_stripClass(item, 'aios-noIcons');
		}
	  catch(e) { }

		// nur, wenn es kein Separator o.. ist
	  if(item.getAttribute('observes') && document.getElementById(item.getAttribute('observes'))) {
	  	broadcaster = document.getElementById(item.getAttribute('observes'));

	  	if(broadcaster.getAttribute('oncommand')) {
	  		commandParent = broadcaster;

	  		if(broadcaster.id == "viewDMSidebar") {
					var dmLabel = broadcaster.getAttribute('label');
					if(dmLabel.indexOf(" (DMT)") < 0) {
						broadcaster.setAttribute('label', dmLabel + " (DMT)");
						broadcaster.setAttribute('tooltiptext', dmLabel + " (Download Manager Tweak)");
					}
				}
	  	}
	  	else if(broadcaster.getAttribute('command')) {
	  		commandParent = document.getElementById(broadcaster.getAttribute('command'));
	  	}

	  	if(commandParent) command = commandParent.getAttribute('oncommand');
	  }
	  else if(item.getAttribute('oncommand')) {
	  	command = item.getAttribute('oncommand');
	  	commandParent = item;
	 	}

		// Label als Tooltip verwenden, wenn kein Tooltiptext eingestellt wurde
		if(!item.getAttribute('tooltiptext') && item.getAttribute('label'))
			item.setAttribute('tooltiptext', item.getAttribute('label'));

		// Event nicht vererben und Menpunkte aktivieren/deaktivieren
		if(command && commandParent) {

			// Event nicht vererben, da er sonst an den Toolbarbutton weitergereicht wrde (zwei toggle-Befehle)
			if(command.indexOf('event.stopPropagation();') < 0) {
				command = command.replace(/ /, "");
				if(command.substring(command.length-1, command.length) != ";") command = command + ";";
				commandParent.setAttribute('oncommand', command + " event.stopPropagation();");
			}

			// den Menpunkt der aktuellen Sidebar aktivieren/deaktivieren
			try { var enable_deac = aios_gPrefBranch.getBoolPref('menus.sidebar.entrydeac'); }
			catch(e) { }

			if(actSidebar && command.indexOf(actSidebar) != -1 && enable_deac) item.setAttribute('disabled', true);
			else item.setAttribute('disabled', false);
		}
  }


	// Meneintrge anzeigen/verbergen (Sidebar ffnen/schlieen und Einstellungen) und verschieben
	var showhideMenuseparator = document.getElementById('aios-sidebar-mitem-sep0');
	var paneltabMitem1 = document.getElementById('aios-sidebar-mitem-paneltab1');
	var paneltabMitem2 = document.getElementById('aios-sidebar-mitem-paneltab2');
	var sidebarshowMitem = document.getElementById('aios-sidebar-mitem-show');
	var sidebarhideMitem = document.getElementById('aios-sidebar-mitem-hide');
	var prefsMitem = document.getElementById('aios-sidebar-mitem-prefs');

	var entries = new Array();
	entries[0] = new Array( "showhide", "paneltab1", "paneltab2", "prefs" );

	// Eintrge/Icons ein- oder ausblenden
	try {
		var enable_showhide = aios_gPrefBranch.getBoolPref('menus.sidebar.showhide');
		var enable_entries = aios_gPrefBranch.getBoolPref('menus.sidebar.entries');

		var returnVals = aios_showHideEntries(entries, 'menus.sidebar.', 'aios-sidebar-mitem-');

		if(enable_showhide && enable_entries) {
			sidebarshowMitem.setAttribute('hidden', !aios_isSidebarHidden());
			sidebarhideMitem.setAttribute('hidden', aios_isSidebarHidden());
		}
		else {
			sidebarshowMitem.setAttribute('hidden', true);
			sidebarhideMitem.setAttribute('hidden', true);
		}
	}
  catch(e) { }


	// Meneintrge ganz nach unten verschieben, wenn das Men noch nicht bearbeitet wurde
	if(!aios_getBoolean(fx_sidebarMenu, 'aios-modified')) {

		fx_sidebarMenu.appendChild(showhideMenuseparator);
		fx_sidebarMenu.appendChild(paneltabMitem1);
		fx_sidebarMenu.appendChild(paneltabMitem2);
		fx_sidebarMenu.appendChild(sidebarshowMitem);
		fx_sidebarMenu.appendChild(sidebarhideMitem);
		fx_sidebarMenu.appendChild(prefsMitem);
	}

	// Sidebarmen als bearbeitet merken
	fx_sidebarMenu.setAttribute('aios-modified', true);
}


/*
	Extras-Men modifizieren
		=> Aufruf durch aios_initSidebar() und aios_savePrefs()
*/
function aios_modFFToolsMenu() {
	var entries = new Array();
	entries[0] = new Array( "prefs" );

	try {
		// Eintrge ein- oder ausblenden
		var returnVals = aios_showHideEntries(entries, 'menus.tools.', 'aios-tools-mitem-');

		var enable_icons = aios_gPrefBranch.getBoolPref("menus.tools.icons");
		var menus = document.getElementsByAttribute('id', 'tools-menu');

		// jedes Tools-Men durchlaufen
		// => falls es mehrere gibt => z.B. wegen CompactMenu
		for(var i = 0; i < menus.length; i++) {
			var childs = menus[i].childNodes[0].childNodes;

			// alle Childs durchlaufen
			for(var j = 0; j < childs.length; j++) {
				if(childs[j].tagName == "menuitem") {

					//Icons ein- oder ausblenden
					if(enable_icons) aios_appendClass(childs[j], 'menuitem-iconic');
			 		else aios_stripClass(childs[j], 'menuitem-iconic');

					// Downloads
					if(childs[j].getAttribute('key') == "key_openDownloads") {
						childs[j].setAttribute('onclick', 'aios_contextEvent(event, this);');
					}
					
					// Addons
					if(childs[j].getAttribute('command') == "Tools:Addons") {
						childs[j].setAttribute('key', 'aiosKey_addons');
						childs[j].setAttribute('onclick', 'aios_contextEvent(event, this);');
					}

					// JavaScript-Konsole
			 		if(childs[j].getAttribute('id') == "javascriptConsole") {
						childs[j].removeAttribute('oncommand');
						childs[j].setAttribute('command', 'Tools:Console');
						childs[j].setAttribute('key', 'aiosKey_console');
						childs[j].setAttribute('onclick', 'aios_contextEvent(event, this);');
			 		}

					// DOM Inspector
					if(childs[j].getAttribute('id') == "menu_inspector") {
						childs[j].setAttribute('onclick', 'aios_contextEvent(event, this);');
					}

					// Page Info
					if(childs[j].getAttribute('command') == "View:PageInfo") {
						childs[j].setAttribute('key', 'aiosKey_pageInfo');
						childs[j].setAttribute('onclick', 'aios_contextEvent(event, this);');
					}
			 	}
			}
		}
	}
  catch(e) { }
}


/*
	Elemente im Kontext-Men ein- oder ausblenden
		=> Aufruf durch das Kontext-Men bei onpopupshowing - gesetzt in aios_initSidebar()
*/
function aios_modFFContextMenu() {
	var entries = new Array();
	entries[0] = new Array( "panels" );

	try {
		// Eintrge u. Icons ein- oder ausblenden
		var returnVals = aios_showHideEntries(entries, 'menus.context.', 'aios-context-mitem-');

		var enable_icons = aios_gPrefBranch.getBoolPref("menus.context.icons");

		if(!enable_icons) {
			aios_stripClass('context-viewsource', 'menuitem-iconic');
			aios_stripClass('context-viewinfo', 'menuitem-iconic');
		}
		else {
			aios_appendClass('context-viewsource', 'menuitem-iconic');
			aios_appendClass('context-viewinfo', 'menuitem-iconic');
		}

		document.getElementById('context-viewsource').removeAttribute('oncommand');
		document.getElementById('context-viewsource').setAttribute('command', 'View:PageSource');
		document.getElementById('context-viewsource').setAttribute('onmouseup', 'aios_contextEvent(event, this);');

		document.getElementById('context-viewinfo').removeAttribute('oncommand');
		document.getElementById('context-viewinfo').setAttribute('command', 'View:PageInfo');
		document.getElementById('context-viewinfo').setAttribute('onmouseup', 'aios_contextEvent(event, this);');
	}
  catch(e) { }
}


/*
	Eintrge/Icons ein- oder ausblenden
		=> Aufruf durch aios_modFFToolsMenu(), aios_modFFContextMenu() und aios_modSidebarMenu()
*/
function aios_showHideEntries(entries, prefPre_tmp, IDPre) {
	var prefPre = prefPre_tmp;
	var returnVals = new Array();

	try {
		var enable_entries = aios_gPrefBranch.getBoolPref(prefPre + "entries");
		var enable_icons = aios_gPrefBranch.getBoolPref(prefPre + "icons");

		var theClass = (enable_icons) ? '' : 'aios-noIcons';

		for(var i = 0; i < entries.length; i++) {

			for(var j = 0; j < entries[i].length; j++) {
				var pref = false;
				// Pref fr jeden Eintrag einlesen
				if(enable_entries) pref = aios_gPrefBranch.getBoolPref(prefPre + entries[i][j]);

				// Eintrge ein- oder ausblenden
				var theID = IDPre + entries[i][j];
				if(document.getElementById(theID)) {
					// falls es mehrere davon gibt => z.B. wegen CompactMenu
					var items = document.getElementsByAttribute('id', theID);
					for(var xy = 0; xy < items.length; xy++) {
						items[xy].hidden = !pref;
					}
				}

				// aktivierte Eintrge je Gruppe zhlen
				if(!returnVals[i]) returnVals[i] = 0;
				if(pref) returnVals[i]++;

				// Icons ein- oder ausblenden
				if(document.getElementById(IDPre + entries[i][j])) {
					var elem = document.getElementById(IDPre + entries[i][j]);

					if(theClass != '') aios_appendClass(elem, theClass);
					else aios_stripClass(elem, 'aios-noIcons');
				}
			}

			// Separator ein- oder ausblenden
			var sep = IDPre + "sep" + i;
			if(document.getElementById(sep)) document.getElementById(sep).hidden = !(returnVals[i] > 0);
		}
	}
  catch(e) { }

  return returnVals;
}


/*
	ffnet die Tab-URL in der Sidebar oder die Sidebar-URL in einem neuen Tab
		=> Aufruf durch <command id="aiosCmd_panelTab1">
										<command id="aiosCmd_panelTab2">
										<toolbarbutton id="paneltab-button">
			 in aios.xul
*/
var aiosNewTab, aiosSidebarTitle;
function aios_panelTab(event) {
	try {
		var ptReverse = aios_gPrefBranch.getBoolPref("paneltab.reverse");
		var enable_rightclick = aios_gPrefBranch.getBoolPref("rightclick");
	}
	catch(e) { }

	if(!event || (!enable_rightclick && event.button == 2)) return false;

	var theSidebar;
	var mode = "sidebar";

	if(typeof event == "object") {
		if((event.shiftKey && event.button == 0)) mode = "window";
		if((event.ctrlKey && event.button == 0) || event.button == 1) mode = "tab";

		// Button-Funktion umkehren?
		if(ptReverse) {
			mode = "tab";
			if((event.shiftKey && event.button == 0)) mode = "window";
			if((event.ctrlKey && event.button == 0) || event.button == 1) mode = "sidebar";
		}

		// Rechtsklick?
		if(enable_rightclick && event.button == 2)  mode = "window";
	}

	if(typeof event == "string") mode = event;


	/*
		in SIDEBAR oeffnen
	*/
	if(mode == "sidebar") {
		var tabHref = top.window.content.location.href;

		// interne FF-Quellen (chrome:/)
		if(tabHref.indexOf("chrome:/") >= 0) {
			theSidebar = aios_isSidebar(tabHref);

			// bei "richtigem" Sidebar-Panel den Sidebar-Toggle-Befehl anwenden
			if(theSidebar) {
				toggleSidebar(theSidebar, true);
			}
			// keine Sidebar (aber chrome://)
			else {
				// aktive Sidebar deaktivieren und persists lschen
				if(document.getElementById(theSidebar)) {
					document.getElementById(theSidebar).removeAttribute('checked');
					document.getElementById("sidebar").removeAttribute("src");
					document.getElementById("sidebar-box").removeAttribute("src");
					document.getElementById("sidebar-box").removeAttribute("sidebarcommand");
				}

				// chrome-URI in Sidebar oeffnen
				top.document.getElementById('sidebar').contentDocument.location.href = tabHref;
				document.getElementById('sidebar-title').setAttribute('value', top.window.content.document.title);
			}
		}
		// about:
		else if(tabHref.indexOf("about:") >= 0) {
			aios_setMultiPanel(tabHref);
		}
		// normale Webseite
		else {
			aios_setMultiPanel('page');
		}
	}
	/*
		in TAB oder FENSTER oeffnen
	*/
	else {
		var newSrc;

		if(fx_sidebarBox.hidden) return false;

		var sidebarDoc = top.document.getElementById('sidebar').contentDocument;
		var sidebarHref = sidebarDoc.location.href;
		aiosSidebarTitle = top.document.getElementById('sidebar-title').getAttribute('value');

		if(sidebarDoc.getElementById('web-panels-browser')) {
			var panelDoc = sidebarDoc.getElementById('web-panels-browser').contentDocument;
			var panelHref = panelDoc.location.href;
		}

		// Bookmark-Manager statt Panel?
		if(sidebarHref == "chrome://browser/content/bookmarks/bookmarksPanel.xul") {
			try { var enable_bmm = aios_gPrefBranch.getBoolPref("paneltab.bm"); }
		  catch(e) { }
			newSrc = (enable_bmm) ? "chrome://browser/content/bookmarks/bookmarksManager.xul" : sidebarHref;
		}
		// statt MultiPanel-XUL die im Panel geffnete Webseite ffnen
		else if(sidebarHref == "chrome://browser/content/web-panels.xul" && mode == "tab") newSrc = panelHref;
		// alle anderen
		else newSrc = sidebarHref;


		// in TAB ffnen
		if(mode == "tab") {
			aiosNewTab = aios_addTab(newSrc);
			if(!enable_bmm) window.setTimeout("aiosNewTab.setAttribute('label', aiosSidebarTitle)", 400);
		}
		// in FENSTER ffnen
		else {
			theSidebar = aios_isSidebar(newSrc);

      // wird zur Abfrage in etd_....xul und etd.js benoetigt
      // sonst wrden extra geffnete Fenster (Downloads, Add-ons) sofort wieder geschlossen
      aios_WIN.aiosIsWindow = true;
      window.setTimeout("aios_WIN.aiosIsWindow=false;", 500);

			if(theSidebar) {
				var cmd = document.getElementById(theSidebar).getAttribute('aios_winCmd');
				if(cmd) eval(cmd);
			}

			if(!theSidebar || (theSidebar && !cmd)) {
				toOpenWindowByType("aiosPanelTabWindow", newSrc);
			}
		}
	}

	return true;
}


/*

*/
function aios_isSidebar(aHref) {
	// wenn es ein "richtiges" Sidebar-Panel ist (vorhandener broadcaster)
	// => richtigen Sidebar-Toggle-Befehl anwenden
	//var isSidebar = null;
	var theSidebar = null;
	var allSidebars = aios_WIN.document.getElementsByAttribute('group', 'sidebar');

	for(var i = 0; i < allSidebars.length; i++) {

		// mu eine ID haben, darf keinen observer haben (Meneintrge usw.) und muss eine Sidebar-URL haben
		if(allSidebars[i].id && !allSidebars[i].getAttribute('observes') && allSidebars[i].getAttribute('sidebarurl')) {

			// aktive Sidebar merken
			if(aios_getBoolean(allSidebars[i].id, 'checked')) theSidebar = allSidebars[i].id;

			if(aHref == allSidebars[i].getAttribute('sidebarurl')) {
				return allSidebars[i].id;
				//isSidebar = true;
			}
		}
	}

	return false;
}


/*
	ffnet div. Fenster u. Manager per Original-Anweisung
		Aufruf durch Toolbarbuttons und Meneintrge
*/
function aios_contextEvent(event, which) {
	try { var enable_rightclick = aios_gPrefBranch.getBoolPref("rightclick"); }
	catch(e) { }

	if(event.button == 0 && (!event.shiftKey && !event.ctrlKey)) return false;		// nur Linksklick
	if(!enable_rightclick && event.button == 2) return false;											// Rechtsklick nicht erlaubt
	if(!event || typeof which != "object") return false;													// kein empfangenes Event

	var mWindow = document.getElementById('main-window');
	if(mWindow && mWindow.getAttribute('chromehidden').indexOf('extrachrome') >= 0) return false; // in einem JS-PopUp

	// Objekt ermitteln, welches das Attribut mit Befehl enthlt (zuvor in aios_setTargets() gesetzt)
	var cmdObj;
	if(which.getAttribute('command')) cmdObj = document.getElementById(which.getAttribute('command'));
	if(!cmdObj && which.getAttribute('observes')) cmdObj = document.getElementById(which.getAttribute('observes'));

	// Modus ermitteln
	var mode = "sidebar";

	// Shift+Linksklick => neues Fenster
	if((event.shiftKey && event.button == 0) || (enable_rightclick && event.button == 2)) {
		if(aios_getBoolean(cmdObj, 'aios_inSidebar') || cmdObj.getAttribute('group') == "sidebar") mode = "window";
	}

	// Ctrl+Linksklick oder Mittelklick => neuer Tab
	if((event.ctrlKey && event.button == 0) || event.button == 1) {
		if(cmdObj.id != "Tasks:InspectPage" && cmdObj.id != "viewDOMInspectorSidebar") mode = "tab";
	}

	// Flock => kein History-Fenster
	if(aios_appVendor == "Flock" && (cmdObj.id == "View:History" || cmdObj.id == "viewHistorySidebar")) return false;
	if(!cmdObj) return false;

	// Befehl ausfhren
	switch(mode) {
		case "sidebar": 	toggleSidebar(cmdObj.getAttribute('aios_sbCmd'));
											break;

		case "window":		// wird zur Abfrage in etd_....xul und etd.js benoetigt
                      // sonst wrden extra geffnete Fenster (Downloads, Add-ons) sofort wieder geschlossen
                      aios_WIN.aiosIsWindow = true;
		                  window.setTimeout("aios_WIN.aiosIsWindow=false;", 500);

		                  eval(cmdObj.getAttribute('aios_winCmd'));
											break;

		case "tab":				aios_addTab(cmdObj.getAttribute('aios_sbUri'));
											break;
	}

	return true;
}


/*
	legt commands fr Fenster fest, die lt. Einstellungen in der Sidebar geffnet werden sollen
		=> dynamisch per JS, damit keinerlei Vernderungen vorgenommen werden, wenn es nicht in der Sidebar geffnet werden soll
				=> bessere Kompatibilitt mit anderen Erweiterungen
		=> Aufruf durch aios_initSidebar()
*/
function aios_setTargets() {

	var targets = new Array();
	targets['bm'] = new Array('View:Bookmarks', 		'viewBookmarksSidebar', 		'bookmarks');
	targets['hi'] = new Array('View:History', 			'viewHistorySidebar', 			'history');
	targets['dm'] = new Array('Tools:Downloads', 		'viewDownloadsSidebar', 		'downloads');
	targets['ad'] = new Array('Tools:Addons', 			'viewAddonsSidebar', 			'addons');
	targets['mp'] = new Array('Tools:MultiPanel', 	    'viewWebPanelsSidebar', 		'multipanel');
	targets['ps'] = new Array('View:PageSource', 		'viewSourceSidebar', 			'source');
	targets['pi'] = new Array('View:PageInfo', 			'viewPageInfoSidebar', 			'pageinfo');
	targets['co'] = new Array('Tools:Console', 			'viewConsoleSidebar', 			'console');
	targets['do'] = new Array('Tasks:InspectPage', 	    'viewDOMInspectorSidebar', 	    'dominspector');

	if(document.getElementById('viewConsole2Sidebar'))
		targets['co'] = new Array('Tools:Console', 		'viewConsole2Sidebar', 		    'console');

  // informative Tooltips und Funktionsumkehrung (PanelTab) aktivieren?
  var prefInfotip = false;
  var ptReverse = false;
  try {
    prefInfotip = aios_gPrefBranch.getBoolPref("infotips");
    ptReverse = aios_gPrefBranch.getBoolPref("paneltab.reverse");

    if(prefInfotip) {
      if(elem_switch) elem_switch.removeAttribute('tooltiptext');
      if(document.getElementById('paneltab-button')) document.getElementById('paneltab-button').removeAttribute('tooltiptext');
    }

    if(document.getElementById('paneltab-button')) {
      if(ptReverse) document.getElementById('paneltab-button').setAttribute('tooltip', 'paneltab-tooltip-reverse');
      else document.getElementById('paneltab-button').setAttribute('tooltip', 'paneltab-tooltip');
    }
  }
  catch(e) { }

	for(var obj in targets) {
		// in Sidebar oeffnen?
		var prefSidebar, prefInfotip;
		try {
			if(obj != "ad") prefSidebar = aios_gPrefBranch.getBoolPref(obj + ".sidebar");
			else prefSidebar = aios_gPrefBranch.getBoolPref("em.sidebar");

			var enable_rightclick = aios_gPrefBranch.getBoolPref("rightclick");
		}
	  catch(e) { }

		var ffObj = document.getElementById(targets[obj][0]);												// Original-Objekt
		var sbObj = document.getElementById(targets[obj][1]);												// Sidebar-Objekt
		var tpObj = document.getElementById(targets[obj][2] + "-tooltip");					// Tooltip
		var btObj = document.getElementById(targets[obj][2] + "-button");						// Button

		if(ffObj && sbObj) {

			// Befehle merken
			// 	=> fr Context-Funktionen - aios_contextEvent() - abfragbar
			// 	=> zuweisbar, wenn nicht mehr in Sidebar geffnet werden soll
			if(!aios_getBoolean(ffObj, 'modByAIOS')) {
				// fr Klicks auf Toolbarbuttons und Meneintrge
				ffObj.setAttribute('aios_winCmd', ffObj.getAttribute('oncommand'));
				ffObj.setAttribute('aios_sbUri', sbObj.getAttribute('sidebarurl'));
				ffObj.setAttribute('aios_sbCmd', targets[obj][1]);
				ffObj.setAttribute('aios_inSidebar', prefSidebar);

				// fr Klicks auf Meneintrge in den Sidebarmens
				sbObj.setAttribute('aios_winCmd', ffObj.getAttribute('oncommand'));
				sbObj.setAttribute('aios_sbUri', sbObj.getAttribute('sidebarurl'));
				sbObj.setAttribute('oncommand', "if(aios_preventDblCmd(event)) " + sbObj.getAttribute('oncommand'));
			}

			var newObj, newCmd, newTp;

			if(prefSidebar) {
				newObj = sbObj;
				newTp = document.getElementById('tooltip-template-sidebar').childNodes[0].cloneNode(true);
			}
			else {
				newObj = ffObj;
				newTp = document.getElementById('tooltip-template-window').childNodes[0].cloneNode(true);
			}

			newCmd = newObj.getAttribute('oncommand');

			// in einem Js-PopUp => winCmd ausfhren
			//  => ansonsten keine PageSource- und PageInfo-Anzeige, da in einem Popup die Sidebar unsichtbar ist
			// verhindern dass zwei Befehle ausgefhrt werden, wenn eine Taste mitgedrueckt wird
			//newCmd = "var mWindow = document.getElementById('main-window'); var extraChrome = false; if(mWindow && mWindow.getAttribute('chromehidden').indexOf('extrachrome') >= 0) { eval(this.getAttribute('aios_winCmd')); return true; } if((event.shiftKey || event.ctrlKey) && (event.explicitOriginalTarget.tagName == 'toolbarbutton' || event.explicitOriginalTarget.tagName == 'menuitem')){ return false; }else{ " + newCmd + " return true; } ";

      newCmd = "var mWindow = document.getElementById('main-window'); var extraChrome = false; if(mWindow && mWindow.getAttribute('chromehidden').indexOf('extrachrome') >= 0) { eval(this.getAttribute('aios_winCmd')); return true; } if(aios_preventDblCmd(event)) " + newCmd + " return true;";
      
			// Befehl zuweisen
			ffObj.setAttribute('oncommand', newCmd);

      // Tooltiptext entfernen, um Info-Tooltips sichtbar zu machen
      if(prefInfotip && btObj) btObj.removeAttribute('tooltiptext');

			// "alte" Tooltip-Zeilen entfernen (sonst werden sie mit jedem Funktionsaufruf zustzlich eingefgt)
			if(tpObj.childNodes.length > 1) tpObj.removeChild(tpObj.childNodes[1]);

			// Rechtsklick im Tooltip aktivieren
			if(enable_rightclick)
				newTp.setAttribute('r3c2', newTp.getAttribute('r3c2') + newTp.getAttribute('rightclick'));

      // DOMI-Tooltip ndern (keine Funktion fr Tab)
			if(targets[obj][2] == "dominspector") {
				newTp.setAttribute('r2c1', newTp.getAttribute('r3c1'));
				newTp.setAttribute('r2c2', newTp.getAttribute('r3c2'));
				newTp.removeAttribute('r3c1');
				newTp.removeAttribute('r3c2');
			}

      // Tooltip zuweisen
			tpObj.appendChild(newTp);

			// Kontext-Men der Toolbarbuttons deaktivieren, wenn Rechtsklick erlaubt ist
			if(btObj && enable_rightclick) btObj.setAttribute('context', '');

			ffObj.setAttribute('modByAIOS', true);
		}

		// Downloads in der Sidebar
		if(obj == "dm" && prefSidebar) var dmSidebar = true;
	}

	// Kontext-Men des PanelTab buttons deaktivieren, wenn Rechtsklick erlaubt ist
	if(enable_rightclick && document.getElementById('paneltab-button')) {
		document.getElementById('paneltab-button').setAttribute('context', '');
		var pttt1 = document.getElementById('paneltab-tooltip').firstChild;
		var pttt2 = document.getElementById('paneltab-tooltip-reverse').firstChild;

		if(pttt1.getAttribute('r3c2').indexOf(pttt1.getAttribute('rightclick')) == -1) {
			pttt1.setAttribute('r3c2', pttt1.getAttribute('r3c2') + pttt1.getAttribute('rightclick'));
		}
		if(pttt2.getAttribute('r3c2').indexOf(pttt2.getAttribute('rightclick')) == -1) {
			pttt2.setAttribute('r3c2', pttt2.getAttribute('r3c2') + pttt2.getAttribute('rightclick'));
		}
	}

	if(dmSidebar) {
		// Download-Observer hinzufgen, falls Downloads in der Sidebar geffnet werden sollen
		//if(obj == "dm" && prefSidebar) {
			var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

  		observerService.addObserver(aios_DownloadObserver, "dl-start",  false);
  		observerService.addObserver(aios_DownloadObserver, "dl-done",  false);

  		// Observer beim Schlieen des Fensters wieder lschen
  		window.addEventListener("unload", function() {
				var aios_myOs = Components.classes["@mozilla.org/observer-service;1"]
                         .getService(Components.interfaces.nsIObserverService);
				aios_myOs.removeObserver(aios_DownloadObserver, "dl-start");
				aios_myOs.removeObserver(aios_DownloadObserver, "dl-done");
				aios_DownloadObserver = null;
			}, false);
		//}
	}

	return true;
}


/*
  verhindert, dass bei Klick + Shift oder Strg der normale Command-Befehl und die Doppelfunktion ausgefhrt wird
    => Aufruf durch die
*/
function aios_preventDblCmd(ev) {
  if(ev.shiftKey || ev.ctrlKey) {
    if(ev.explicitOriginalTarget.tagName == 'toolbarbutton' || ev.explicitOriginalTarget.tagName == 'menuitem') return false;
  }
  return true;
}


/*
	ffnet die Sidebar,
		1. wenn ein Download gestartet wird ...
		2. der Manager geffnet werden soll und ...
		3. das Ziel die Sidebar sein soll
*/
var aios_DownloadObserver = {
  observe: function (aSubject, aTopic, aState) {

    switch (aTopic) {
	    case "dl-start":
				var enable_open = aios_gPref.getBoolPref("browser.download.manager.showWhenStarting");

				var comElem = document.getElementById('Tools:Downloads');
				if(enable_open && comElem.getAttribute('oncommand').indexOf('viewDownloadsSidebar') >= 0) {
					toggleSidebar("viewDownloadsSidebar", true);
				}
	      break;

	    case "dl-done":
	    	var enable_close = aios_gPref.getBoolPref("browser.download.manager.closeWhenDone");

				var sideSrc = document.getElementById('sidebar').getAttribute('src');
	    	if(enable_close && sideSrc.indexOf('downloads.xul') >= 0) {
	    		toggleSidebar();
	    	}
	    	break;
    }
  }
};





/*
	prft, ob das Browserfenster maximiert ist oder sich im Vollbildmodus befindet
		=> Aufruf durch aios_checkThinSwitch()
*/
function aios_isWinMax() {
	var windowMax = document.getElementById('main-window').getAttribute('sizemode') == "maximized";

	var maxWidth = window.outerWidth > screen.availWidth;
	var maxHeight = window.outerHeight > screen.availHeight;
	if((maxWidth && maxHeight) || window.fullScreen) windowMax = true;

	return windowMax;
}


/*
	prft, ob die Sidebar gerade sichtbar/unsichtbar ist => abhngig von der Sidebar-Methode
*/
function aios_isSidebarHidden() {
	aios_getObjects();

	try {
		var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
	}
	catch(e) { }

	if(aios_collapseSidebar) return (fx_sidebarBox.hidden || fx_sidebarBox.collapsed);
	else return fx_sidebarBox.hidden;
}


/*
	Autohide-Feature initialisieren
		=> Aufruf durch aios_initSidebar() und
*/
var aiosFocus = true;
function aios_initAutohide() {
	// Zustand des Autohide-Buttons einstellen
	document.getElementById('aios-enableAutohide').setAttribute('checked', aios_gPrefBranch.getBoolPref("gen.switch.autoshow"));

	// Autohide-Feature-Funktion hinzufgen
	fx_sidebarBox.addEventListener("mouseover", function() {
		if(document.getElementById('appcontent'))
			document.getElementById('appcontent').addEventListener("mouseover", aios_autoShowHide, true);
	}, true);

	window.addEventListener("focus", function(e) { aiosFocus = true; }, true);
	window.addEventListener("blur", function(e) { aiosFocus = false; }, true);
}


/*
	Autohide ein- bzw. ausschalten per Toolbarbutton
		=> Aufruf durch broadcaster 'aios-enableAutohide'
*/
function aios_toggleAutohide(which) {
	try {
		aios_gPrefBranch.setBoolPref("gen.switch.autoshow", aios_getBoolean(which, 'checked'));
	}
	catch(e) { }
}