
var searchObj, clearObj;
var aios_checkElems = new Array( 'aios-enableAutoClose', 'aios-viewOpenClose', 'aios-viewClear', 'aios-EBS-toolbar-mitem' );


/*
	Initialisierung
		=> Aufruf durch onload in bm_hi.xul
*/
function aios_initBmHi() {
	var popUp;
	aios_synchElements(aios_checkElems);

	// Tools-Buttton anzeigen?
	try {
		var enable_tools;

		if(document.getElementById('bookmarksPanel')) enable_tools = aios_gPrefBranch.getBoolPref("bm.tools");
		else enable_tools = aios_gPrefBranch.getBoolPref("hi.tools");

		document.getElementById('viewButton').hidden = !enable_tools;
	}
	catch(e){ }
	
	searchObj = document.getElementById("search-box");
	clearObj = document.getElementById("clearSearch");

	// Tooltip, focus- und blur-Funktionen hinzufgen
	// 	=> erst hier bei init(), weil es sonst Skript-Fehler geben wrde
	// 	=> nicht aktivieren in Verbindung mit Bookmark Duplicate Detector
	if(typeof Bookmarkdd != "object") {
	    searchObj.setAttribute('onfocus', 'aios_focusBlurText("focus");');
	    searchObj.setAttribute('onblur', 'aios_focusBlurText("blur");');
	}
	
	// Chronik
	// 	=> dem "Extras"-Men den Separator und die drei Menpunkte hinzufgen
	popUp = document.getElementById("viewButton").firstChild;
	if(document.getElementById("bylastvisited")) {
		popUp.appendChild(document.getElementById('openClose-separator'));
		document.getElementById('openClose-separator').hidden = false;

		popUp.appendChild(document.getElementById('aios-enableAutoClose'));
		popUp.appendChild(document.getElementById('aios-rememberFolder'));
		popUp.appendChild(document.getElementById('aios-scrollToFolder'));

		popUp.appendChild(document.getElementById('openClose-separator').cloneNode(true));

		popUp.appendChild(document.getElementById('aios-viewOpenClose'));
		popUp.appendChild(document.getElementById('aios-viewClear'));
	}

	// falls der "Tools"-Button ein <button> ist (FF >= 1.5), diesen durch einen <toolbarbutton> ersetzen
	if(document.getElementById("viewButton").localName == "button") {
		var viewButton = document.getElementById("viewButton");
		popUp = viewButton.firstChild.cloneNode(true);
		var attr = viewButton.attributes;

		// alten <button> entfernen
		viewButton.parentNode.removeChild(viewButton);

		var new_viewButton = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "toolbarbutton");

		// alle Attribute des alten Buttons bernehmen
		for(var i = 0; i < attr.length; i++) {
			new_viewButton.setAttribute(attr[i].name, attr[i].value);
		}

		// neuen <toolbarbutton> einfgen
		popUp.setAttribute('onpopupshowing', 'aios_checkOptions();');
		new_viewButton.appendChild(popUp);
		searchObj.parentNode.appendChild(new_viewButton);
	}

	// Fix fr Enhanced Bookmarks Search (Elemente entfernen, wenn EBS nicht verfgbar ist)
	if(typeof ebsBMPanelInit != "function" && document.getElementById('viewPopUp')) {
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-EBS-separator'));
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-EBS-toolbar-mitem'));
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-EBS-mitem'));
	}

	// Fix fr Advanced Bookmarks Search (Elemente entfernen, wenn ABS nicht verfgbar ist)
	if(!document.getElementById('abs-button') && document.getElementById('viewPopUp')) {
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-ABS-separator'));
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-ABS-toolbar-mitem'));
		document.getElementById('viewPopUp').removeChild(document.getElementById('aios-ABS-mitem'));
	}

	if(typeof ebsBMPanelInit == "function" && document.getElementById('abs-button') && document.getElementById('viewPopUp')) {
	  document.getElementById('viewPopUp').removeChild(document.getElementById('aios-ABS-separator'));
	  document.getElementById('viewPopUp').removeChild(document.getElementById('aios-ABS-toolbar-mitem'));
	}
	
	// Fix fr Flock
	if(aios_appVendor == "Flock") {
		document.getElementById('openCloseFolder').hidden = true;
		document.getElementById('clearSearch').hidden = true;
		document.getElementById('viewButton').hidden = true;
	}
}


/*
	experimentelle Elemente aktivieren/deaktivieren
		=> Aufruf durch onpopupshowing des Tools-Buttons
*/
function aios_checkOptions() {
	document.getElementById('aios-rememberFolder').setAttribute('disabled', !aios_getBoolean("aios-enableAutoClose", "checked"));
	document.getElementById('aios-scrollToFolder').setAttribute('disabled', !aios_getBoolean("aios-enableAutoClose", "checked"));
}


/*
	Alle Ordner ffnen (Linksklick) oder alle Ordner schlieen (Rechtsklick)
		=> Aufruf durch den Button #openCloseFolder in der bm_hi.xul
*/
function aios_openCloseFolder(event) {
	if(typeof event != "object") return;

	if(event.button == 1 || event.button == 2) aios_acbtf.closeAll();
	else aios_acbtf.openAll();
}


/*
"Suchbegriff" im Suchfeld anzeigen oder verbergen
		=> Aufruf durch onfocus() und onblur() des Suchfeldes
*/
function aios_focusBlurText(mode) {
	var strings = document.getElementById("propSetStrings");
	var blurText = strings.getString('bm_hi.search.blur');
	    
	if(mode == "focus" && searchObj.value == blurText) {
		searchObj.className = "";
		searchObj.value = "";
		clearObj.setAttribute('disabled', false);
	}
	else if(mode == "blur" && searchObj.value == "") {
	    searchObj.className = "blur";
		searchObj.value = blurText;
		clearObj.setAttribute('disabled', true);
	}
}


/*
	Suche und Ansicht zurcksetzen
		=> Aufruf durch #clearSearch in bm_hi.xul und die Meneintrge im "Extras"-Men
*/
function aios_clearSearch() {
	searchObj.value = "";
	searchObj.focus();

	// Ansicht aktualisieren
	if(document.getElementById('bookmarks-view')) {
		if(typeof searchBookmarks == "function") searchBookmarks(searchObj.value);          // Fx 3
	    else document.getElementById('bookmarks-view').searchBookmarks(searchObj.value);    // Fx <= 2
	}
	else {
	    searchHistory(searchObj.value);
	}
}


/*
	Autoclose Bookmark & History Folder by Ronny Perinke (mod by exxile, based on ac-btf_0_55_5.xpi)
*/
const aios_acbtf = {
	_BTree: null,
	_HTree: null,
	_Prefs:
	{
		//CloseSidebar: false, //mod by eXXile
		ScrollToRow: false,
		SelectLastUsedFolder: true,
		//ShowToolbar: true //mod by eXXile
	},
	get prefRoot()
	{
		return "extensions.aios.acbh."; //mod by eXXile
	},
	set prefRoot(aString){},
	get PrefsIFace()
	{
		var prefsIFace = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPref);
		var prefsIFace = prefsIFace.getBranch(this.prefRoot);
		this.__defineGetter__("PrefsIFace", function() { return prefsIFace; });
		return prefsIFace;
	},
	/*get StringBundle()*/ //function deleted by eXXile
	//#######################################
	//########	/private functions and properties	########
	//########						########
	//#######################################
	
	/**
		implement EventListener Interface
		only used for addEventListener()
	*/
	handleEvent: function BMB_handleEvent(aEvent)
	{
		switch(aEvent.type)
		{
			case "load":
				this.init();
				break;
			
			case "unload":
				this.quit();
				break;
		}
	},
	
	init: function()
	{
		
		try
		{
			this._BTree = document.getElementById("bookmarks-view");
			this._BTree.setAttribute("onclick", 'aios_acbtf.onClick(event, "bookmarks")');	//ndert den standard onclick-event //mod by eXXile
		}
		catch(e)
		{
			//dump("ac-btf: could no get element \"bookmarks-view\"\nError Message:\n"+e+"\n");
		}
		
		try
		{
			this._HTree = document.getElementById("historyTree");
			this._HTree.setAttribute("onclick", 'aios_acbtf.onClick(event, "history")');		//ndert den standard onclick-event //mod by eXXile
		}
		catch(e)
		{
			//dump("ac-btf: could no get element \"historyTree\"\nError Message:\n"+e+"\n");
		}
		
		this.loadPrefs();
		
		this.PrefObserver.register(this.prefRoot);
		//this.showHideToolbar(); //mod by eXXile
		//this.addSettingsButton(); //mod by eXXile
		
		if (this._Prefs.SelectLastUsedFolder)
		{
			var tbo, lastRowToSelect;
			if (this._BTree && this.PrefsIFace.prefHasUserValue("lastBookmarkFolder"))
			{
				lastRowToSelect = this.PrefsIFace.getIntPref("lastBookmarkFolder");
				tbo = this._BTree.treeBoxObject;
				setTimeout(this.selectFolder, 10, lastRowToSelect, tbo);
			}
			
			if (this._HTree && this.PrefsIFace.prefHasUserValue("lastHistoryFolder"))
			{
				lastRowToSelect = this.PrefsIFace.getIntPref("lastHistoryFolder");
				tbo = this._HTree.treeBoxObject;
				setTimeout(this.selectFolder, 10, lastRowToSelect, tbo);
			}
		}
	},
	quit: function()
	{
		this.PrefObserver.unregister();
		/*this.removeSettingsButton();
		
		if (this._Prefs.CloseSidebar)
		{
			var sb_box = window.top.document.getElementById("sidebar-box");
			sb_box.setAttribute("sidebarcommand", "");
			window.top.document.persist("sidebar-box", "sidebarcommand");
		}*/ //mod by eXXile
	},
	
	loadPrefs: function()
	{
		this.PrefsIFace = this.prefRoot;	// reset PrefBranch to default value
		//load user settings
		//this._Prefs.CloseSidebar = this.PrefsIFace.getBoolPref("CloseSidebar"); //mod by eXXile
		this._Prefs.SelectLastUsedFolder = aios_getBoolean("aios-rememberFolder", "checked"); //mod by eXXile
		this._Prefs.ScrollToRow = aios_getBoolean("aios-scrollToFolder", "checked"); //mod by eXXile
		//this._Prefs.ShowToolbar = this.PrefsIFace.getBoolPref("ShowToolbar"); //mod by eXXile
	},
	
	/*showHideToolbar: function()
	addToolbar: function()
	removeToolbar: function()
	updateTBButtons: function(aEvent)
	addSettingsButton: function()
	removeSettingsButton: function()*/ //functions deleted by eXXile
	
	selectFolder: function(index, tbo)
	{
		if (tbo.view.rowCount >= index)
		{
			tbo.view.selection.select(index);
			if (tbo.view.rowCount > tbo.getPageLength())	// check if we really need to scroll
				tbo.scrollToRow(index);
			tbo.ensureRowIsVisible(index);
		}
	},
	
	onClick: function(aEvent, sidebarType)
	{	aios_acbtf.loadPrefs();	//mod by eXXile - falls die Einstellungen gendert wurden, whrend die Sidebar offen ist
		if (!aEvent || !sidebarType || (sidebarType != 'history' && sidebarType != 'bookmarks'))
		{
			return;
		}
		
		// don't do anything if it was a right-click
		if (aEvent.button == 2)
		{
			return;
		}
		
		var dotoggle = (aEvent.button != 0)?false:true;	//wenn es kein links-klick war, dann fhre nur die standardaktion aus
		
		const tree = (aios_acbtf._BTree)?aios_acbtf._BTree:aios_acbtf._HTree;	//mod by eXXile
		
		var tbo = tree.treeBoxObject;
		
		//wenn man auf das + zeichen vor dem ordner klickt, dann soll er einfach nur aufgehen und die anderen nicht geschlossen werden
		var row = {}, col = {}, obj = {};
		tbo.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
		if (row.value == -1 || obj.value == "twisty")
		{
			return;
		}
		
		var mouseInGutter = false;
		if (sidebarType == 'history')
		{
		      var x = { }, y = { }, w = { }, h = { };
		      tbo.getCoordsForCellItem(row.value, col.value, "image", x, y, w, h);
		      mouseInGutter = aEvent.clientX < x.value;
		}
		
		var tboView = tbo.view
		var modifKey = aEvent.shiftKey || aEvent.ctrlKey || aEvent.altKey || aEvent.metaKey  || aEvent.button == 1;
		row = row.value;
		if (dotoggle && tboView.isContainer(row) && !modifKey)
		{
			tboView.toggleOpenState(row);	//ffnet oder schliesst den ordner; Standardvorgang bei Ordnern
			
			// mod by eXXile => nur die anderen schlieen, wenn auch aktiviert
			if(!aios_getBoolean("aios-enableAutoClose", "checked")) return;
			
			//jetzt der teil, der die anderen offenen ordner schliesst
			var parents = new Array();
			//nun werden alle ober-ordner des aktuellen gesucht
			while (row != -1)
			{
				parents.push(row);
				row = tboView.getParentIndex(row);
			}
			parents.reverse();	//dreht reihenfolge im array um
			
			for (var i = tboView.rowCount-1; i>=0; i--)	//geht einfach jede zeile durch und testet ...
			{
				if (parents.length > 0 && parents[parents.length-1] == i)
				{	//bei den ober-ordnern soll sich nix tun, sollen also offen bleiben
					parents.pop();
				}
				else
				{
					if (tboView.isContainer(i) && tboView.isContainerOpen(i))
					{
						//andere elemente, die ordner sind, sollen geschlossen werden
						tboView.toggleOpenState(i);
					}
				}
			}
			
			if (aios_acbtf._Prefs.ScrollToRow &&  (tboView.rowCount > tbo.getPageLength()))		//falls gescrollt werden soll, aber nur wenn das auch wirklich ntig ist // mod by eXXile
			{
				tbo.scrollToRow(tree.currentIndex);
			}
			tbo.ensureRowIsVisible(tree.currentIndex);	// scrollt zum index nur wenn ntig.
			
			if (aios_acbtf._Prefs.SelectLastUsedFolder) // mod by eXXile
			{
				switch(sidebarType)
				{
					case 'bookmarks':
						aios_acbtf.PrefsIFace.setIntPref("lastBookmarkFolder", tree.currentIndex); // mod by eXXile
						break;
						
					case 'history':
						aios_acbtf.PrefsIFace.setIntPref("lastHistoryFolder", tree.currentIndex); // mod by eXXile
						break;
				}
			}
			return;
		}
		
		// open item
		if (!mouseInGutter && aEvent.originalTarget.localName == "treechildren" && (aEvent.button == 0 || aEvent.button == 1))
		{
			// Clear all other selection since we're loading a link now. We must
			// do this *before* attempting to load the link since openURL uses
			// selection as an indication of which link to load.
			tboView.selection.select(row);
			if (typeof(PlacesUIUtils) == "object" && typeof(PlacesUIUtils.openNodeWithEvent) == "function")
			{
				PlacesUIUtils.openNodeWithEvent(tree.selectedNode, aEvent);
				return;
			}
			if (typeof(PlacesUtils) == "object" && typeof(PlacesUtils.openNodeWithEvent) == "function")
			{
				PlacesUtils.openNodeWithEvent(tree.selectedNode, aEvent);
				return;
			}
			if (tree.controller && typeof(tree.controller.openSelectedNodeWithEvent) == "function")
			{
				tree.controller.openSelectedNodeWithEvent(aEvent);
				return;
			}
			if (sidebarType == 'bookmarks' && typeof(tree.openItemClick) == "function")
			{
				tree.openItemClick(aEvent, 1);
				return;
			}
			if (sidebarType == 'history' && typeof(openURL) == "function")
			{
				openURL(aEvent);
				return;
			}
		}
	},
	
	closeAll: function()
	{
		var aView;
		if (aios_acbtf._BTree) // mod by eXXile
		{
			aView = aios_acbtf._BTree.treeBoxObject.view; // mod by eXXile
			try
			{
				this.PrefsIFace.clearUserPref("lastBookmarkFolder");
			}
			catch(e)
			{}
		}
		
		if (aios_acbtf._HTree) // mod by eXXile
		{
			aView = aios_acbtf._HTree.treeBoxObject.view; // mod by eXXile
			try
			{
				this.PrefsIFace.clearUserPref("lastHistoryFolder");
			}
			catch(e)
			{}
		}
		
		if (aView)
		{
			for (var i = aView.rowCount-1; i>=0; i--)
			{
				if (aView.isContainer(i) && aView.isContainerOpen(i))
				{
					aView.toggleOpenState(i);
				}
			}
		}
	},
	openAll: function()
	{
		var aView, viewbutton;
		if (aios_acbtf._BTree) // mod by eXXile
		{
			aView = aios_acbtf._BTree.treeBoxObject.view; // mod by eXXile
			try
			{
				this.PrefsIFace.clearUserPref("lastBookmarkFolder");
			}
			catch(e)
			{}
		}
		
		if (aios_acbtf._HTree) // mod by eXXile
		{
			aView = aios_acbtf._HTree.treeBoxObject.view; // mod by eXXile
			viewbutton = document.getElementById("viewButton");
			try
			{
				this.PrefsIFace.clearUserPref("lastHistoryFolder");
			}
			catch(e)
			{}
		}
		
		var doOnce = (viewbutton)?(viewbutton.getAttribute("selectedsort") == "day"):false;
		
		if (aView)
		{
			var oldrows = -1;
			var rows = aView.rowCount;
			do
			{
				for (var i = rows-1; i>=0; i--)
				{
					if (aView.isContainer(i) && !aView.isContainerOpen(i))
					{
						aView.toggleOpenState(i);
					}
				}
				
				oldrows = rows;
				rows = aView.rowCount;
			}
			while(rows != oldrows && !doOnce);
		}
	},
	
	PrefObserver:
	{		
		get CI()
		{
			return Components.interfaces;
		},
		set Ci(){},	// make it kind of a constant ;-)
		// http://kb.mozillazine.org/Dev_:_Using_preferences#Using_preferences_observers
		_branch: null,
		_registered: false,
		register: function(aPrefRoot)
		{
			if (this._registered)
			{
				return;
			}
			
			//dump("aios_acbtf.PrefObserver: adding observer ...\n"); // mod by eXXile
			const prefBranch = (typeof(this.CI.nsIPrefBranch2) == "object")?"nsIPrefBranch2":"nsIPrefBranchInternal";
			var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(this.CI.nsIPrefService);
			
			this._branch = prefService.getBranch(aPrefRoot);
			this._branch.QueryInterface(eval("this.CI."+prefBranch));
			this._branch.addObserver("", this, false);
			this._registered = true;
		},
		
		unregister: function()
		{
			if (!this._registered)
			{
				return;
			}
			
			//dump("aios_acbtf.PrefObserver: removing observer ...\n"); // mod by eXXile
			this._branch.removeObserver("", this);
			this._registered = false;
		},
		
		QueryInterface: function(aIID)
		{
			if (!aIID.equals(this.CI.nsISupports) && !aIID.equals(this.CI.nsIObserver))
			{
				throw Components.results.NS_ERROR_NO_INTERFACE;
			}
			return this;
		},
		
		observe: function(aSubject, aTopic, aData)
		{
			//dump("aios_acbtf.PrefObserver: observe() called ...\n"); // mod by eXXile
			if (typeof(aios_acbtf) == "undefined") // mod by eXXile
			{
				//dump("aios_acbtf.PrefObserver: aios_acbtf is undefined!\n"); // mod by eXXile
				return;
			}
			if (aTopic != "nsPref:changed")
			{
				//dump("aios_acbtf.PrefObserver: " + aTopic + " is not the right topic for me.\n"); // mod by eXXile
				return;
			}
			
			// aSubject is the nsIPrefBranch we're observing (after appropriate QI)
			// aData is the name of the pref that's been changed (relative to aSubject)
			//dump("aios_acbtf.PrefObserver: name of the pref which was changed: " + aData +"\n"); // mod by eXXile
			aios_acbtf.loadPrefs(); // mod by eXXile
			/*switch (aData)
			{
				case "ShowToolbar":
					aios_acbtf.showHideToolbar();
					break;
			}*/ // mod by eXXile
		}
	}
}

window.addEventListener('load', aios_acbtf, false); // mod by eXXile
window.addEventListener('unload', aios_acbtf, false); // mod by eXXile