/* $Id: wmerror.h,v 1.4 2000/02/02 04:55:38 komatsu Exp $ */

#ifndef __WM_ERROR_H__
#define __WM_ERROR_H__

#include <glib.h>
#include <X11/Xlib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

enum {
    WM_ERROR_SUCCESS       = 1 << Success,
    WM_ERROR_BAD_REQUEST   = 1 << BadRequest,
    WM_ERROR_BAD_VALUE     = 1 << BadValue,
    WM_ERROR_BAD_WINDOW    = 1 << BadWindow,
    WM_ERROR_BAD_PIXMAP    = 1 << BadPixmap,
    WM_ERROR_BAD_ATOM      = 1 << BadAtom,
    WM_ERROR_BAD_CURSOR    = 1 << BadCursor,
    WM_ERROR_BAD_FONT      = 1 << BadFont,
    WM_ERROR_BAD_MATCH     = 1 << BadMatch,
    WM_ERROR_BAD_DRAWABLE  = 1 << BadDrawable,
    WM_ERROR_BAD_ACCESS    = 1 << BadAccess,
    WM_ERROR_BAD_ALLOC     = 1 << BadAlloc,
    WM_ERROR_BAD_COLOR     = 1 << BadColor,
    WM_ERROR_BAD_GC        = 1 << BadGC,
    WM_ERROR_BAD_ID_CHOICE = 1 << BadIDChoice,
    WM_ERROR_BAD_NAME      = 1 << BadName,
    WM_ERROR_BAD_LENGTH    = 1 << BadLength,
    WM_ERROR_BAD_IMPLEMENTATION = 1 << BadImplementation
};

typedef guint wmErrorIgnoreMask;

wmErrorIgnoreMask wm_error_get_ignore_mask(void);
void wm_error_set_ignore_mask(wmErrorIgnoreMask mask);
void wm_error_init(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_ERROR_H__ */
