/* $Id: wmlabel.c,v 1.1 2000/11/11 23:41:54 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmlabel.h"
#include "wmdesign.h"

WmLabelItem *wm_label_item_new(WmLabelType type, gpointer data)
{
    WmLabelItem *label;
    label = g_malloc(sizeof(WmLabelItem));
    label->type = type;
    label->data = data;

    return label;
}

WmLabelList *wm_label_list_new_with_string(gchar *string)
{
    WmLabelList *list;
    list = g_list_append(NULL, wm_label_item_new(WM_LABEL_TEXT, string));
    return list;
}

GtkWidget *wm_label_new(WmLabelList *list)
{
    GtkWidget *label, *item;
    label = gtk_hbox_new(FALSE, 0);
    
    while (list) {
	switch (WM_LABEL_TYPE(list)) {
	case WM_LABEL_TEXT:
	    item = gtk_label_new(WM_LABEL_DATA(list));
	    gtk_box_pack_start(GTK_BOX(label), item, FALSE, FALSE, 0);
	    gtk_widget_show(item);
	    break;

	case WM_LABEL_IMG:
	    wm_design_xpm_pack(label, WM_LABEL_DATA(list));
	    break;

	default:
	}
	list = list->next;
    }
    return label;
}
