/* $Id: wmrc.h,v 1.12 2000/11/11 23:41:54 komatsu Exp $ */

#ifndef __WM_RC_H__
#define __WM_RC_H__

#include <gtk/gtk.h>
#include "wmlabel.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define AMATERUSRC ".amaterus"

gchar *rc_error;

enum {
    RC_MENU_EMPTY,
    RC_MENU_EXIT,
    RC_MENU_RESTART,
    RC_MENU_SYSTEM,
    RC_MENU_EXEC,
    RC_MENU_HR,
    RC_MENU_MENU
/*     RC_MENU_LAST */
};

struct _WmRcMenuItem
{
    gint type;
    gchar *command;
/*     gchar *title; */
    WmLabelList *title;
};
typedef struct _WmRcMenuItem WmRcMenuItem;

struct _WmRcMenu
{
    gchar     *id;
    gchar     *title;
    GList     *item;
    GtkWidget *widget;
};
typedef struct _WmRcMenu WmRcMenu;

struct _WmRcWindowBorder
{
    gint   width;
    gchar *frame;
};
typedef struct _WmRcWindowBorder WmRcWindowBorder;

enum {
    RC_WINDOW_GEOMETRY_X = 1 << 1,
    RC_WINDOW_GEOMETRY_Y = 1 << 2
};

struct _WmRcWindowGeometry
{
    gint flags;
    gint x;
    gint y;
};
typedef struct _WmRcWindowGeometry WmRcWindowGeometry;

struct _WmRcWindowTitle
{
    gchar *format;
};
typedef struct _WmRcWindowTitle WmRcWindowTitle;

struct _WmRcWindow
{
    gchar              *class; /* Ūˤ class != id Ȥ */
    WmRcWindowBorder   *border;
    WmRcWindowGeometry *geometry;
    WmRcWindowTitle    *title;
};
typedef struct _WmRcWindow WmRcWindow;

struct _WmRcFrameWidget
{
    gchar *type;
    gchar *ref;
};
typedef struct _WmRcFrameWidget WmRcFrameWidget;

enum {
    RC_FRAME_PACK_H,
    RC_FRAME_PACK_V
};

struct _WmRcFrame
{
    gchar *name;
    gint   pack;
    GList *widget;
};
typedef struct _WmRcFrame WmRcFrame;

struct _WmRc
{
    GData *menus; /* Υ˥塼 */
    GData *windows;
};
typedef struct _WmRc WmRc;

void wm_rc_system_set_func(GtkSignalFunc func, const gchar *id);
GtkSignalFunc wm_rc_system_get_func(gchar *id);
WmRcWindow *wm_rc_window_get(gchar *id);
WmRcFrame  *wm_rc_frame_get(gchar *name);
WmRc *wm_rc_init(gchar *filename);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_RC_H__ */
