/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __ODBCSTATEMENT_HPP
#define __ODBCSTATEMENT_HPP

#include "include.hpp"
#include <sql.h>
#include "statement.hpp"

/** Class for executing SQL query and querying results.
    \deprecated{The ODBC classes are not in use at the moment}
    Call \c ODBCDatabase::execQuery to acquire an instance of this class.
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class ODBCStatement: public Statement
{
public:
  /** Constructor requiring SQLHDBC handle.
      Call \c ODBCDatabase::execQuery to acquire an instance of this class.
      @see ODBCDatabase::execQuery */
  ODBCStatement( SQLHDBC connection, const std::string &query ) throw (Error);
  /// Destructor frees the statement handle.
  virtual ~ODBCStatement(void);
  ///
  virtual int getNumCols(void) throw (Error);
  ///
  virtual std::string getColAttr( int col ) throw (Error);
  ///
  virtual ResultRowPtr &fetchRow(void) throw (Error);
protected:
  ///
  SQLHSTMT statement;
  ///
  ResultRowPtr resultRow;
};

///
typedef boost::shared_ptr< ODBCStatement > ODBCStatementPtr;

#endif
