/* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include "timer.hpp"

double timer::elapsed(void) const
{
  struct timeval actualTime;
  gettimeofday( &actualTime, NULL );

  // Use timersub-define, which does overflow-handling.
  struct timeval difference;
  timersub( &actualTime, &time, &difference );

  return difference.tv_sec + difference.tv_usec * 1.0E-6;
}
