/***************************************************************************
                          ApollonBrowseView.h  -  description
                             -------------------
begin		: Dec 05 2003
copyright	: (C) 2002 by Bastiaan Naber, (C) 2002 by Robert Wittams
email		: bastiaan@ricardis.tudelft.nl
description	: 

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APOLLONBROWSEVIEW_H
#define APOLLONBROWSEVIEW_H

#include <qvbox.h>
#include <qdict.h>

class KIconLoader;

class QLabel;
class QListView;
class QListViewItem;
class QPopupMenu;
class QString;
class QStringList;

class ApollonBrowseView : public QVBox
{
	Q_OBJECT

	public:
		ApollonBrowseView(QWidget *parent, const int id, const QString &query);
		~ApollonBrowseView();

		QString  query() { return m_query; }
		int      index() { return 0; } // no realm-searching for users is possible

	public slots:
		void stopSearch();
		void deleteThis();
		void itemDoubleClicked(QListViewItem *item);
		void downloadItemClicked(QListViewItem *item, bool recursive = false, QString subdir = "");
		void addItem(QString searchReply);
		void popUp(QListViewItem *item, const QPoint &point, int col);

		void download();
		void downloadFolder();
		void downloadFolderRecursively();

	signals:
		void giftAddRequest(QString, QString, QString, QString, QString);
		void giftCancelBrowseRequest(int);

	protected:
		void download(QListViewItem *item, bool recursive = false);

		int                    m_id;
		QListView             *m_browseResults;

	private:
		QListViewItem *getParent(QString dir);

		QLabel                *m_iconLabel;
		QLabel                *m_label;
		QListViewItem         *m_rootListItem;
		QDict<QListViewItem>   m_items;
		QPopupMenu            *m_popupMenu;
		QPopupMenu            *m_folderPopupMenu;
		QString                m_query;
		QString                m_labelTextSearch;
		QString                m_labelTextComplete;
		QString                m_completed;
		KIconLoader           *m_loader;
};

#endif
