#ifndef FILESTORAGE_H_
#define FILESTORAGE_H_

#include "config.h"

class acbuf;
class header;

/*!
 * 
 * Interface: All access methods that a download agent needs to know and to use when fetching and storing data
 */
class dlstorage {
public:
	// downloader instruments
	
	/// \brief @return TRUE: accepted and assigned, FALSE: another conflicting assignment found
	virtual bool AssignDownloaderUnlessConflicting()=0; 
	virtual bool ReleaseDownloaderUnlessBusy()=0;
	virtual bool StoreNewHead(const header & h)=0;
	/*!
	 * 
	 * Saves the file data. Opens the file as needed. nOffset and nRest are read and updated.
	 */
	virtual long StoreData(const char *data, const unsigned int size, off_t nOffset)=0;
	virtual void Finalize(long nNewContLen)=0;
	virtual void SetFailureMode(MYSTD::string const & FailureMessage, bool bNonFatal=false)=0;
	virtual void AddTransferCount(UINT nLen)=0;
	virtual void GetStatusEx(long & nCachedLen, long &nContLen, bool & bIsDynType)=0;
	
	virtual MYSTD::string ToString()=0;
	virtual void GetHeader(header &hOut)=0;

};

typedef SHARED_PTR<dlstorage> tDlStoragePtr;

#endif /*FILESTORAGE_H_*/
