/*
 * ARCload (c) 2005 Stanislaw Skowronek
 */

#ifndef ENDIAN_H
#define ENDIAN_H

#include <endian.h>

void swap32(unsigned int *x)
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	*x = (((*x >> 16) & 0x0000FFFF) | ((*x << 16) & 0xFFFF0000));
	*x = (((*x >> 8) & 0x00FF00FF) | ((*x << 8) & 0xFF00FF00));
#endif
}
void swap16(unsigned short *x)
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	*x = (((*x >> 8) & 0x00FF) | ((*x << 8) & 0xFF00));
#endif
}

#endif /* ENDIAN_H */
