/*
    Copyright (C) 2000-2007 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string>

#include "editing.h"

#include "i18n.h"

using namespace std;

// This involves some cpp magic. --taybin

#define SNAPTYPE(a) /*empty*/
#define SNAPMODE(a) /*empty*/
#define REGIONLISTSORTTYPE(a) /*empty*/
#define MOUSEMODE(a) /*empty*/
#define ZOOMFOCUS(a) /*empty*/
#define DISPLAYCONTROL(a) /*empty*/

namespace Editing {

// SNAPTYPE
#undef SNAPTYPE
#define SNAPTYPE(s) if (!strcmp(type, #s)) {return s;}
SnapType
str2snaptype (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return SnapToBar;
}

#undef SNAPTYPE
#define SNAPTYPE(s) N_(#s),
const char *snaptypestrs[] = {
	#include "editing_syms.h"
	0
};
#undef SNAPTYPE
#define SNAPTYPE(a) /*empty*/

// SNAPMODE
#undef SNAPMODE
#define SNAPMODE(s) if (!strcmp(type, #s)) {return s;}
SnapMode
str2snapmode (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return SnapNormal;
}

#undef SNAPMODE
#define SNAPMODE(s) N_(#s),
const char *snapmodestrs[] = {
	#include "editing_syms.h"
	0
};
#undef SNAPMODE
#define SNAPMODE(a) /*empty*/


// REGIONLISTSORTTYPE
#undef REGIONLISTSORTTYPE
#define REGIONLISTSORTTYPE(s) if (!strcmp(type, #s)) {return s;}
RegionListSortType
str2regionlistsorttype (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return ByName;
}

#undef REGIONLISTSORTTYPE
#define REGIONLISTSORTTYPE(s) N_(#s),
const char *regionlistsorttypestrs[] = {
	#include "editing_syms.h"
	0
};
#undef REGIONLISTSORTTYPE
#define REGIONLISTSORTTYPE(a) /*empty*/

// MOUSEMODE
#undef MOUSEMODE
#define MOUSEMODE(s) if (!strcmp(type, #s)) {return s;}
MouseMode
str2mousemode (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return MouseObject;
}

#undef MOUSEMODE
#define MOUSEMODE(s) N_(#s),
const char *mousemodestrs[] = {
	#include "editing_syms.h"
	0
};
#undef MOUSEMODE
#define MOUSEMODE(a) /*empty*/

// ZOOMFOCUS
#undef ZOOMFOCUS
#define ZOOMFOCUS(s) if (!strcmp(type, #s)) {return s;}
ZoomFocus
str2zoomfocus (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return ZoomFocusPlayhead;
}

#undef ZOOMFOCUS
#define ZOOMFOCUS(s) N_(#s),
const char *zoomfocusstrs[] = {
	#include "editing_syms.h"
	0
};
#undef ZOOMFOCUS
#define ZOOMFOCUS(a) /*empty*/

// DISPLAYCONTROL
#undef DISPLAYCONTROL
#define DISPLAYCONTROL(s) if (!strcmp(type, #s)) {return s;}
DisplayControl
str2displaycontrol (const string & str) {
	const char* type = str.c_str();
	#include "editing_syms.h"
	return FollowPlayhead;
}

#undef DISPLAYCONTROL
#define DISPLAYCONTROL(s) N_(#s),
const char *displaycontrolstrs[] = {
	#include "editing_syms.h"
	0
};
#undef DISPLAYCONTROL
#define DISPLAYCONTROL(a) /*empty*/


} // namespace Editing

