/* $Id: ArkLoader.cpp,v 1.25 2003/03/26 15:43:01 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <Ark/ArkLoader.h>
#include <Ark/ArkSystem.h>

#include <algorithm> 


namespace Ark
{

   extern void ark_AddTgaLoader (Loaders *loaders);
   extern void ark_AddTexLoader (Loaders *loaders);
   extern void ark_AddPngLoader (Loaders *loaders);
   extern void ark_AddPSysLoader (Loaders *loaders);
   extern void ark_AddJpgLoader (Loaders *loaders);
   extern void ark_AddMatLoader (Loaders *loaders);
   extern void ark_AddArkMDLLoader (Loaders *loaders);
   extern void ark_AddSeqLoader (Loaders *loaders);
   extern void ark_Add3dsLoader (Loaders *loaders);
   
   void ark_AddLibLoaders (Loaders *loaders)
   {
      ark_AddTgaLoader (loaders);
      ark_AddTexLoader (loaders);
      ark_AddPngLoader (loaders);
      ark_AddPSysLoader (loaders);
      ark_AddJpgLoader (loaders);
      ark_AddMatLoader (loaders);
      ark_Add3dsLoader (loaders);
      ark_AddSeqLoader (loaders);
      ark_AddArkMDLLoader (loaders);
   }
   
// Stub
   Loader::~Loader ()
   {}
   
   Loaders::Loaders()
   {}
   
   Loaders::~Loaders()
   {
      for (LoaderLI i = m_Loaders.begin(); i != m_Loaders.end(); ++i)
      {
	 delete (*i);
      }
      
      m_Loaders.clear();
   }

// Find the first loader capable of loading the file pointed to by \c name;
// It will update the progress every \c granularity percents.
   bool
   Loaders::Load (Object *vis, const String &name,
		  Cache *cache,
		  Progress *progress, int granularity)
   {
      bool loaded = false;
      
      assert (vis != NULL);
      
      // Get "arguments", so it is possible to do things such as
      // Load (..., "test.tga?mipmaps=0", ...)
      String rname;
      String args;
      
      String::size_type pos = name.find('?');
      if (pos == String::npos)
      {
	  rname = name;
      }
      else
      {
	  rname = name.substr(0, pos);
	  args = name.substr(pos + 1, String::npos);
      }

      AutoReadStream rs (rname, std::ios::in | std::ios::binary);
      std::ifstream& stream = rs.Get();
      
      for (LoaderLI i = m_Loaders.begin(); loaded == false && i != m_Loaders.end(); ++i)
      {
	 bool cap = (*i)->CanLoad (vis->Type(), stream, rname, args);
	 stream.seekg (0, std::ios::beg);
	 
	 if (cap)
	 {
	    loaded = (*i)->Load (vis, stream, rname, args, cache,
				 progress, granularity);
	    if (loaded)
	       Sys()->Log ("load: %s: %s\n",
			   name.c_str(), (*i)->GetInformations().c_str());
	 }
      }
      
      return true;
   }
   
// Add a loader to the list of file loaders. The loader should be available
// until the application is quitted.
   bool
   Loaders::Add (Loader *loader)
   {
      if (loader == NULL)
	 return false;
      
      m_Loaders.push_back(loader);
      return true;
   }
   
/// Remove a loader from the loader list. The loader has to be destroyed
/// after that, if it isn't necessary any more.
   bool
   Loaders::Remove (Loader *loader)
   {
       // keeps iterator to see if one or more loader is removed
       LoaderLI i = std::remove(m_Loaders.begin(), m_Loaders.end(), loader);
       const bool removed = (i != m_Loaders.end());

       m_Loaders.erase(i, m_Loaders.end());

       return removed;
   }
   
} // namespace Ark
