/* $Id: ArkSequence.h,v 1.7 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_SEQUENCE_H
#define ARK_SEQUENCE_H

#include <Ark/ArkObject.h>
#include <vector>

namespace Ark
{
	class Sequence;
	typedef Ptr<Sequence> SequencePtr;
   
   class Bone;

   struct ARK_DLL_API BoneFrame
   {
	 Vector3 m_Position;
	 Vector3 m_Rotation;
   };
   
   typedef std::vector< BoneFrame > Keyframe;

   class ARK_DLL_API Sequence : public Object
   {
     protected:
	 /**
	  * Delete the given sequence.
	  */
	 virtual ~Sequence ();

     public:
	 /**
	  * Create an empty sequence with the given name.
	  */
	 Sequence (const String &name);

	 /** Read that sequence from a file. */
	 bool Read (const String &filename, Stream &file);

	 /**
	  * Find the two frame corresponding to the given time (the one
	  * before, and the one after), and give factors between 0 and
	  * 1 for each of those frames.
	  *
	  * \return false if time is out of range
	  */
	 bool ComputeFrameFactors (scalar time,
				   int *frame0, scalar *fact0,
				   int *frame1, scalar *fact1) const;

	 /**
	  * Get the rotation and translation for the given bone,
	  * at the given frames, with the given interpolation factors.
	  * \c Adjs is a pointer to controller values.
	  *
	  * \return rotation, and translation are filled with the correct
	  *         values.
	  */
	 void GetTransformation (Bone &bone,
				 const BoneFrame &f0, scalar fact0,
				 const BoneFrame &f1, scalar fact1,
				 const scalar *adjs,
				 Vector3 *translation,
				 Quat *rotation) const;

     public:

	 /// Number of frames per seconds in this sequence.
	 scalar m_FPS;

	 /// Time this sequence takes to play.
	 scalar m_EndTime;

	 /// Keyframe data for this sequence.
	 typedef std::vector< Keyframe > KeyframeList;
	 KeyframeList m_Keyframes;

	 /**
	  * Maximum axis-aligned bounding box the model will take
	  * while playing this sequence.
	  */
	 BBox m_BBox;
   };

}

#endif
