/* $Id: ArkTypes.h,v 1.14 2002/10/11 01:10:06 zongo Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_TYPES_H
#define ARK_TYPES_H

#include <Ark/Ark.h>

#ifndef NULL
#define NULL 0
#endif

#include <stdarg.h>
#include <sys/types.h> //defines uint & cie
#include <ctype.h>

typedef signed char          int8;
typedef short int            int16;

typedef unsigned char        uchar;
typedef unsigned char        uint8;
typedef unsigned short int   uint16;

typedef float                float32;
typedef double               float64;
typedef float32              scalar;

#ifdef WIN32
typedef unsigned int         uint;
typedef unsigned long        ulong;
typedef unsigned short       ushort;
#endif

// FIXME : UNICODE
typedef char tchar;

namespace Ark
{

class ARK_DLL_API Text
{
  public:
   inline static bool IsSpace (tchar c) {return isspace(c) != false;}
   inline static bool IsAlpha (tchar c) {return isalpha(c) != false;}
   inline static bool IsAlnum (tchar c) {return isalnum(c) != false;}
   inline static bool IsDigit (tchar c) {return isdigit(c) != false;}
   inline static bool IsXdigit (tchar c) {return isxdigit(c) != false;}

   static tchar *translate (const tchar *string);
};

// FIXME : translate is not defined !
#if 0
#ifdef ENABLE_NLS
#define _(str) (Ark::Text::translate (str))
#else
#define _(str) (str)
#endif
#endif

#ifndef _
#define _(str) (str)
#endif

}




#endif
