/* $Id: ArkVariable.cpp,v 1.3 2002/10/07 20:40:18 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkVariable.h>

#include <sstream>

#include <locale.h>

namespace Ark
{

/**
* Returns the value of the variable as a string.
*/
String
IntegerVariable::GetAsString() const
{
    std::ostringstream os;
    os << m_Value;
    return os.str();
}
	 

/**
* Returns the value of the variable as a string.
*/
String
ScalarVariable::GetAsString() const
{
    std::ostringstream os;
    os << m_Value;
    return os.str();
}


/**
* Returns the value of the variable as an integer.
*/
int 
StringVariable::GetAsInteger() const
{
	int val = 0;
	StringToInt(m_Value, val);
    return val;
}


/**
 * Returns the value of the variable as an scalar (floating point value).
 */
scalar 
StringVariable::GetAsScalar() const
{
	scalar val = 0.0f;
	StringToScalar(m_Value, val);
    return val;
}
	 

// namespace Ark
}

