/* $Id: Client.cpp,v 1.21 2003/03/12 21:50:01 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkSystem.h>

#include <Client/Client.h>
#include <Client/RemoteUpdater.h>

namespace Client
{

   Client *g_Client = NULL;
   Client::Client (int argc, char **argv)
   {
      g_Client = this;

      m_Config = Ark::Sys()->Cfg();
      m_Config->Load ("{game}/config/client.cfg");

      m_World = NULL;
      m_Renderer = NULL;
      m_Player = NULL;

      m_MaxFPS = m_Config->GetScalar ("client::MaxFPS", 70);
   }

// Destroy the client and all data used by it.
   Client::~Client()
   {
      if (m_Updater)
	 delete m_Updater;
   
      if (m_Renderer)
	 delete m_Renderer;
   }

   void
   Client::Login (const Ark::String &name,
		  const Ark::String &pass)
   {
      if (m_Renderer == NULL)
	 return;

      m_Updater = CreateUpdater
	 (Ark::Sys()->Cfg()->GetStr("client::Updater", "ark::Updater::Engine"),
	  &m_Renderer->GetCache());

      if (m_Updater == NULL)
	 //FIXME.. Handle this better.
	 Ark::Sys()->Fatal("Cannot create main updater."); 

      m_Player = m_Updater->Login (name,pass);

      m_World = m_Updater->GetWorld();

      if (m_World == NULL)
	 Ark::Sys()->Fatal("Cannot create updater, giving up.\n");

      m_World->Init (Ark::WORLD_HAS_RENDERING);

      m_Renderer->GetCache().Clear(false);
      m_Renderer->GetCache().MemReport();
   }

}
