#ifndef SPLASH_WIDGET_H
#define SPLASH_WIDGET_H

#include <Client/Widget.h>

namespace Client
{
   // Draw the splashscreen.
   class SplashWidget : public Widget
   {
      public:
	 virtual ~SplashWidget() {}

	 virtual void Render(UIRenderer *ui)
	 {
	    // FIXME : splash shouldnt be of the same size than the normal game
	    // window, and DrawTexturedRectangle coordinates shouldnt be
	    // hardcoded that would fix the problem with the splashscreen if
	    // the x/y factors dont match
	    Ark::TexturePtr tex;
	    int width = Ark::Sys()->Cfg()->GetInt ("renderer::Width", 800);
            int height = Ark::Sys()->Cfg()->GetInt ("renderer::Height", 600);
	    
	    ui->Rdr()->GetCache().Get (Ark::V_TEXTURE,
				       "{game}/data/misc/splashscreen.jpg",
				       tex);

	    if (tex)
	    {
		tex->Configure();

		ui->SetTexture (tex);
		ui->DrawTexturedRectangle(0, 0, width, height);
		ui->Flush();
	    }

	 }

   };
}

#endif
