/*
** ArkRPG - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CLIENT_WIDGET_H
#define CLIENT_WIDGET_H

#include <Client/UIRenderer.h>

namespace Client
{
    /**
     * Base class of the GUI system of Ark.
     * It just defines a comportment that a widget should have.
     * TODO: Comment the member functions definitions.
     */    
   class Widget : public Ark::DRefCounter
   {
      public:
	 virtual ~Widget() {}
	 
	 virtual void Render (UIRenderer *renderer) = 0;
	
	 virtual void HandleKey (bool down, int mods, int key) {}
	 virtual void HandleMButton (bool down, int b, int x, int y) {}
	 virtual void HandleMotion (int state, int x, int y) {}
   };

   typedef Ark::Ptr<Widget> WidgetPtr;
}

#endif
