/* $Id: Raytrace.cpp,v 1.3 2003/03/19 09:25:06 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
 #include <config.h>
#endif

#include <Ark/ArkModelState.h>
#include <Modules/Collision/Collision.h>

namespace Ark
{

   extern void CD_GetTriangle (uint triangleindex,
			       Vector3 *points, 
			       int *mat,
			       CDSubmodel *mdl);

   bool
   CDRaytrace::RayTest (const Opcode::AABBQuantizedNoLeafNode *node)
   {

      if (!RayTest (&node->mAABB))
	 return false;

      if (node->HasLeaf())
      {
	 CD_GetTriangle (node->GetPrimitive(),
			 m_Triangle, &m_Material, m_SubMdl);

	 if (m_Ray.HitTriangle (m_Triangle[0],
				m_Triangle[1],
				m_Triangle[2],
				&m_Pos))
	    return true;
      }
      else if (RayTest(node->GetPos()))
	 return true;

      if (node->HasLeaf2())
      {
	 CD_GetTriangle (node->GetPrimitive2(),
			 m_Triangle, &m_Material, m_SubMdl);

	 if (m_Ray.HitTriangle (m_Triangle[0],
				m_Triangle[1],
				m_Triangle[2],
				&m_Pos))
	    return true;
      }
      else if (RayTest(node->GetNeg()))
	 return true;
      return false;
   }

   bool
   CDRaytrace::RayTest (const Opcode::QuantizedAABB *ab)
   {
      Vector3 Pa(float(ab->mCenter[0]),
		 float(ab->mCenter[1]),
		 float(ab->mCenter[2]));
      Vector3 ea(float(ab->mExtents[0]),
		 float(ab->mExtents[1]),
		 float(ab->mExtents[2]));
      
      Pa.Scale (m_CenterCoeff);
      ea.Scale (m_ExtentCoeff);

      /// Create bounding box...
      BBox bb;
      bb.m_Min = Pa;
      bb.m_Max = Pa;

      bb.m_Min -= ea;
      bb.m_Max += ea;

      return m_Ray.HitBBox (bb, &Pa);
   }
   
   bool
   CDRaytrace::RayTest (Opcode::AABBQuantizedNoLeafTree *tree,
			CDSubmodel *submdl)
   {
      m_SubMdl = submdl;

      m_CenterCoeff = *((Vector3*) &tree->mCenterCoeff);
      m_ExtentCoeff = *((Vector3*) &tree->mExtentsCoeff);

      return RayTest (tree->GetNodes());
   }

   bool
   CDRaytrace::RayTest (const ModelState &ms,
			const Ray &ray,
			Collision &collision)
   {
      Model *mdl = const_cast<ModelState&>(ms).GetModel();

      if (mdl == NULL)
	 return false;

      CDModel *cdmdl = static_cast<CDModel*>(mdl->m_CDModel);

      if (cdmdl == NULL)
	 return false;

      Matrix44 imatrix = ms.m_Matrix;
      imatrix.Invert();

      // To avoid transforming the bounding boxes, we simply transform
      // the ray by the invert of the matrix...
      // (ie Collision in object space)

      Vector3 from = imatrix.Transform(ray.m_From);
      Vector3 to = imatrix.Transform(ray.m_To);

      m_Ray = Ray (from, to);

      bool col = false;
      for (size_t i = 0; i < cdmdl->m_SubModels.size(); i++)
      {
	 if (RayTest ((Opcode::AABBQuantizedNoLeafTree*)
		      cdmdl->m_SubModels[i]->m_CDModel->GetTree(),
		      cdmdl->m_SubModels[i]))
	 {
	    col = true;
	    break;
	 }
      }

      if (!col)
	 return false;

      // Transform back from object space to world space...
      m_Pos = ms.m_Matrix.Transform (m_Pos);
      m_Triangle[0] = ms.m_Matrix.Transform (m_Triangle[0]);
      m_Triangle[1] = ms.m_Matrix.Transform (m_Triangle[1]);
      m_Triangle[2] = ms.m_Matrix.Transform (m_Triangle[2]);

      // Fill collision structure.
      collision.m_Pos = m_Pos;
      collision.m_Flags = Collision::ENTITY
	 | Collision::POSITION
	 | Collision::PLANE;
      collision.m_Plane = Plane::GetTriPlane (m_Triangle[0],
					      m_Triangle[1],
					      m_Triangle[2]);

      collision.m_Material =
	 const_cast<ModelState&>(ms).m_Skin->GetMaterial(m_Material);

      return true;
   }

}
