/* $Id: LuaListTable.cpp,v 1.5 2002/12/21 17:34:02 tharibo Exp $ 
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <Modules/Lua/LuaListTable.h>

namespace Ark
{
  /****************************************************************************
   * Construct a LuaTable, the table being at the given index.
   *
   * There should be a problem here if the table is not created from scratch
   * with the factory... There may be elements in the table but they will be
   * replaced by some calls to addElement(). We should handle this here and in
   * the factory...
   ****************************************************************************/
  LuaListTable::LuaListTable(lua_State* L, int index)
    : LuaTable(L, index), m_LastIndex(-1)
  {
  }

  /****************************************************************************
   * Destructor
   ****************************************************************************/
   LuaListTable::~LuaListTable()
  {
  }

  /****************************************************************************
   * Add an element to the list
   *
   * \param element The element to add.
   ****************************************************************************/
  void LuaListTable::addElement(double element)
  {
    lua_pushnumber(m_L, element);
    lua_rawseti(m_L, m_Index, ++m_LastIndex);
  }

  /****************************************************************************
   * Add an element to the list
   *
   * \param element The element to add.
   ****************************************************************************/
  void LuaListTable::addElement(const char* element)
  {
    lua_pushstring(m_L, element);
    lua_rawseti(m_L, m_Index, ++m_LastIndex);
  }

  /****************************************************************************
   * Add an element to the list
   *
   * \param element The element to add.
   ****************************************************************************/
  void LuaListTable::addElement(void* element)
  {
    lua_pushuserdata(m_L, element);
    lua_rawseti(m_L, m_Index, ++m_LastIndex);
  }

  /****************************************************************************
   * Add an element to the list
   *
   * \param element The element to add.
   ****************************************************************************/
  void LuaListTable::addElement(const LuaTable& element)
  {
    // Copy the given table at the top of the stack, than add it in our table.
    lua_pushvalue(m_L, element.index());
    lua_rawseti(m_L, m_Index, ++m_LastIndex);
  }

  /****************************************************************************
   * Constructs a LuaListTable from scratch. This creates a new table on the
   * stack.
   *
   * \param L The lua state where we are going to create the table.
   ****************************************************************************/
  LuaListTable* LuaListTable::createTable(lua_State* L)
  {
    lua_newtable(L);
    return new LuaListTable(L, -1);
  }
}

