// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2004  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                  

#ifndef __OptionVec_h__
#define __OptionVec_h__

//stdc++ includes
#include <string>
#include <vector>
using namespace std;
	
class OptionItem{
	public:
		enum {OPT_ACC=0x1, OPT_GCC=0x2, OPT_FILE=0x4, OPT_FILE_GCC=0xC, OPT_FILE_ACC=0x14};
		typedef int FLAG;
	

	private:
		string _name;
		string _argument;
		FLAG _flag;

	public:
		OptionItem(string name, string arg,FLAG flag):_name(name),_argument(arg),_flag(flag){}
		OptionItem(string name,FLAG flag):_name(name),_flag(flag){}
		OptionItem(const OptionItem& opt):_name(opt._name),_argument(opt._argument),_flag(opt._flag){}

		const string& name(){return _name;}
		void name(string newname){_name=newname;}

		const string& arg(){return _argument;}
		void arg(string newarg){_argument=newarg;}

		const FLAG flag(){return _flag;}
		void flag(FLAG flag) {_flag = flag;}
};

class OptionVec: public vector<OptionItem>{

public:
	typedef vector<OptionItem> vec_t;
	
private:
	//vec_t _options;

public:
	//OptionVec(){}
	//OptionVec(const OptionVec& optvec):_options(optvec._options){}
	
	// Add a new Option
	void pushback(string name, string arg, OptionItem::FLAG flag);
	
//	
//	// Add a new Option
	void pushback(string name, OptionItem::FLAG flag);

	
	//vec_t& options(){return _options;}

	const string& getString();
	
	const string& getString(OptionItem::FLAG);
};
	


#endif //__OptionVec_h__

