// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PointCutEvaluator_h__
#define __PointCutEvaluator_h__

#include "PointCut.h"

namespace Puma {
  class ErrorStream;
  class ACAspectInfo;
  class ACPointcutInfo;
  class CFunctionInfo;
  class CT_AdviceDecl;
  class CTree;
} // namespace Puma

using namespace Puma;

class PointCutExpr;
class PointCutContext;
class Binding;

class PointCutEvaluator {
  ErrorStream &_err;
  PointCutContext &_context;

 public:
  PointCutEvaluator (ErrorStream &e, PointCutContext &c) :
    _err (e), _context (c) {}

  // evaluate a pointcut expression
  void work (PointCut &pc, Binding &binding, CTree *pc_node,
	     JoinPointLoc::join_point_type expected);

  // create and destroy pointcut expression syntax trees
  PointCutExpr *create (CTree *pc_node, JoinPointLoc::join_point_type expected);
  void destroy (PointCutExpr * expr);
  
private:
  PointCutExpr *create_tree (CTree *node);
};

#endif // __PointCutEvaluator_h__
