// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashKey_h__
#define __StrHashKey_h__

#include "Puma/StrCol.h"
#include "Puma/Chain.h"

namespace Puma {


class StrHashKey : public Chain {
  unsigned int m_Magic;
  unsigned int m_Len;
  const char  *m_Str;

  StrHashKey () : m_Len (0), m_Str (0) {}

public:
  StrHashKey (int m, const char *s, int l) : 
    m_Magic (m), m_Len (l), m_Str (StrCol::dup (s, l)) {}

  unsigned int getMagic () const { return m_Magic; }
  unsigned int length () const { return m_Len; }
  const char  *c_str () const { return m_Str; }
};


} // namespace Puma

#endif /* __StrHashKey_h__ */
