#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTemplateInfo_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTemplateInfo_h__
#define __CTemplateInfo_h__

// class and function template info
// knows the template parameters and the template definition
// knows the template instantiations

#include "Puma/CStructure.h"

namespace Puma {


class CT_TemplateDecl;
class CTemplateParamInfo;
class CT_ExprList;
class CT_TemplateName;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTemplateInfo : public CStructure {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CObjectInfo *_ObjectInfo;
  CTemplateInfo *_Base;
  bool _isSpecial;
  CT_TemplateName *_SpecializationName;
  unsigned _Depth;

  Array<CTemplateParamInfo*> _Params;
  Array<CObjectInfo*> _Instances;
  Array<CObjectInfo*> _PseudoInstances;
  Array<CTemplateInfo*> _Specializations;

public: 
  CTemplateInfo ();
  ~CTemplateInfo ();
  
  void removeLinks ();

  bool isFunction () const;                // is function template?
  bool isClass () const;                   // is class template?
  bool isAttribute () const;               // is definition of static data member?
  bool isBaseTemplate () const;            // is not specialization?
  bool isSpecialization () const;          // is not base template?
  
  void increaseDepth ();                   // increase instantiation depth
  void decreaseDepth ();                   // decrease instantiation depth
  unsigned Depth () const;                 // return instantiation depth

  CObjectInfo *ObjectInfo () const;        // the template definition
  CT_TemplateDecl *Tree () const;
  CTemplateInfo *BaseTemplate () const;
  CTemplateParamInfo *newTemplateParam ();
  
  unsigned Parameters () const;
  CTemplateParamInfo *Parameter (unsigned) const;
  CT_ExprList *DefaultArgument (unsigned) const;

  unsigned Instances () const;
  CObjectInfo *Instance (unsigned);
  void addInstance (CObjectInfo *);
  void addPseudoInstance (CObjectInfo *);
  void removeInstance (const CObjectInfo *);
  
  unsigned Specializations () const;
  CTemplateInfo *Specialization (unsigned);
  void addSpecialization (CTemplateInfo *);
  void removeSpecialization (const CTemplateInfo *);
  void isSpecialization (bool);
  void SpecializationName (CT_TemplateName *);
  CT_TemplateName *SpecializationName () const;

  void deleteTemplateParam (const CTemplateParamInfo *); 
  void ObjectInfo (CObjectInfo *);
  void BaseTemplate (CTemplateInfo *);

  static bool equalArguments (CTemplateInstance *, CTemplateInstance *);

private:
  void linkInstance (CObjectInfo *);
  CTemplateInfo *nextTemplate (CTemplateInfo *tinfo) const; 
};

inline CTemplateInfo::CTemplateInfo () :
  CStructure (CObjectInfo::TEMPLATE_INFO),
  _ObjectInfo ((CObjectInfo*)0),
  _Base ((CTemplateInfo*)0),
  _isSpecial (false),
  _SpecializationName ((CT_TemplateName*)0),
  _Depth (0),
  _Instances (20, 20) // big enough?
 {}

inline void CTemplateInfo::increaseDepth () 
 { _Depth++; }
inline void CTemplateInfo::decreaseDepth ()
 { if (_Depth) _Depth--; }
inline unsigned CTemplateInfo::Depth () const
 { return _Depth; }

inline unsigned CTemplateInfo::Instances () const
 { return _Instances.length (); }
inline CObjectInfo *CTemplateInfo::Instance (unsigned i)
 { return _Instances.lookup (i); }
inline void CTemplateInfo::addInstance (CObjectInfo *inst)
 { _Instances.append (inst); linkInstance (inst); }
inline void CTemplateInfo::addPseudoInstance (CObjectInfo *inst)
 { _PseudoInstances.append (inst); linkInstance (inst); }

inline unsigned CTemplateInfo::Specializations () const
 { return _Specializations.length (); }
inline CTemplateInfo *CTemplateInfo::Specialization (unsigned i)
 { return _Specializations.lookup (i); }
inline void CTemplateInfo::isSpecialization (bool v)
 { _isSpecial = v; }
inline CT_TemplateName *CTemplateInfo::SpecializationName () const 
 { return _SpecializationName; }
inline void CTemplateInfo::SpecializationName (CT_TemplateName *name)
 { _SpecializationName = name; }

inline unsigned CTemplateInfo::Parameters () const
 { return _Params.length (); }
inline CTemplateParamInfo *CTemplateInfo::Parameter (unsigned i) const
 { return _Params.lookup (i); }

inline CObjectInfo *CTemplateInfo::ObjectInfo () const
 { return _ObjectInfo; }
inline void CTemplateInfo::ObjectInfo (CObjectInfo *info)
 { if (info && (void*)info < (void*)0x10) *(int*)info = 0;
   _ObjectInfo = info; }
inline CTemplateInfo *CTemplateInfo::BaseTemplate () const
 { return _Base; }
 
inline bool CTemplateInfo::isFunction () const
 { return ObjectInfo () && ObjectInfo ()->FunctionInfo (); }
inline bool CTemplateInfo::isClass () const
 { return ObjectInfo () && ObjectInfo ()->ClassInfo (); }
inline bool CTemplateInfo::isAttribute () const
 { return ObjectInfo () && ObjectInfo ()->AttributeInfo (); }
inline bool CTemplateInfo::isBaseTemplate () const
 { return ! _isSpecial && ! (_Base); }
inline bool CTemplateInfo::isSpecialization () const
 { return _Base || _isSpecial; }

inline CT_TemplateDecl *CTemplateInfo::Tree () const 
 { return (CT_TemplateDecl*)CObjectInfo::Tree (); }


} // namespace Puma

#endif /* __CTemplateInfo_h__ */

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTemplateInfo_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTemplateInfo_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CTemplateInfo_h__
