// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __syntax_tree_token__
#define __syntax_tree_token__

// Class PreTreeToken makes it possible to let tokens be
// a part of a syntax tree.

#include "Puma/PreTree.h"
#include "Puma/Token.h"

namespace Puma {


class PreTreeToken : public PreTree {
  Token *_token;
        
public:
  PreTreeToken (Token *token) : _token (token) {}

  // Accept() is part of the visitor concept to put class
  // functionallity into another class.
  void accept (PreVisitor &v)
    { v.visitPreTreeToken (this); }            
        
  // Return the start or end token.
  Token *startToken () const { return _token; }
  Token *endToken () const   { return _token; }
        
  // Return the token.
  Token *token () const      { return _token; }
};


} // namespace Puma

#endif /*__syntax_tree_token__ */
