// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScanBuffer_h__
#define __CScanBuffer_h__

#include "Puma/ScanBuffer.h"
#include "Puma/Array.h"

namespace Puma {


class CScanBuffer {
  ScanBuffer *next_buffer;
  bool on_new_line;
  int nl_pos;

  void check ();

public:
  void decorate (ScanBuffer *nb) { next_buffer = nb; }
  inline char next ();
  inline void reset ();
  inline void accept (int len);
  inline void retry ();
  bool new_line () const { return on_new_line; }
  char *token () { return next_buffer->token (); }
  int len () const { return next_buffer->len (); }
  void more (int len) { next_buffer->more (len); }
  ScanBuffer::State state () const { return next_buffer->state (); }
};


inline char CScanBuffer::next () {
  char character = next_buffer->next ();
  if (character == '\n' && nl_pos == -1)
    nl_pos = len () - 1;
  check ();
  return character;
}

inline void CScanBuffer::reset () { 
  next_buffer->reset (); 
  on_new_line = true;
  nl_pos = -1;
  check ();
}


inline void CScanBuffer::retry () {
  nl_pos = -1;
  next_buffer->retry ();
}


inline void CScanBuffer::accept (int len) {
  on_new_line = (nl_pos >= 0 && nl_pos < len);
  nl_pos = -1;
  next_buffer->accept (len);
}

} // namespace Puma

#endif // __CScanBuffer_h__
