#ifeq ($(MAKELEVEL),0)
#$(error Sorry, this makefile is not intended to be \
#used directly. Please use the makefile in the toplevel \
#directory of the PUMA source tree instead)
#endif

#-------------------------------------------------
# variables 
#-------------------------------------------------

include $(ROOT)/vars.mk

HEADERS   := $(shell find $(STEP1)/inc -name "*")
HEADERSDEP:= $(STEP2)/.inc

ACOBJECTS := $(notdir $(filter-out $(DONTWEAVE), $(SOURCES)))
ACOBJECTS += $(notdir $(LEMSOURCES:.lem=.cc))
ACOBJECTS := $(addprefix $(STEP2)/src/, $(ACOBJECTS))

CPPFLAGS  += -I $(STEP1)/inc -I $(STEP1)/aspects

ACFILES   := $(addprefix $(STEP1)/aspects/, $(notdir $(ASPECTS)))
ACDEPS    := $(addprefix --include , $(ACFILES))
ACFLAGS   += $(addprefix -a , $(ACFILES))
ACFLAGS   += $(CPPFLAGS) -I $(STEP1)/src -r $(GENDIR)/puma.acp
ACFLAGS   += --config $(CONFIG) --gen_size_type __SIZE_TYPE__


DEPDIR    := $(STEP1)/dep
DEPFILES  := $(addprefix $(DEPDIR)/, $(notdir $(ACOBJECTS:.cc=.d)))

#-------------------------------------------------
# targets
#-------------------------------------------------

vpath %.cc  $(STEP1)/src
vpath %.d   $(DEPDIR)

all: showinfo dontweave $(ACOBJECTS) $(HEADERSDEP)

showinfo:
	@echo 
	@echo "---"
	@echo "Weaving PUMA for TARGET=$(TARGET)"
	@echo "  Weaver = $(AC) $(ACFLAGS)"
	@echo "---"
	@echo 

dontweave:
	@echo "Copying sources not to weave..."
	@cp -p $(DONTWEAVE) $(STEP2)/src
	@cp -p $(STEP1)/src/*.ot $(STEP2)/src

#-------------------------------------------------
# rules
#-------------------------------------------------

$(STEP2)/src/%.cc : %.cc
	@echo "Calling ac++ on $(notdir $<)..."
	@$(AC) $(ACFLAGS) -p $(STEP1) -c $< -o $@
	@echo "$@: \\" > $(addprefix $(DEPDIR)/, $(notdir $(<:.cc=.d)))
	@grep "^#line" $@ | grep -v $(STEP2) | grep -v "<ac" | grep -v "\.ah" | \
	 awk '{print $$3}' | sed -e "s#\"##g" | sort | uniq |\
	 sed -e "s/$$/ \\\/g" >> $(addprefix $(DEPDIR)/, $(notdir $(<:.cc=.d)))
	@echo $(ACFILES) >> $(addprefix $(DEPDIR)/, $(notdir $(<:.cc=.d)))


$(HEADERSDEP): $(HEADERS) $(ACFILES)
	@echo "Generating library header files..."
	@touch $(HEADERSDEP)
	@cd $(STEP1) && $(AC) $(ACFLAGS) -i -p. -d$(STEP2)
	@cp -p $(STEP2)/aspects/*.ah $(STEP2)/inc/Puma
	@cp -pr $(STEP2)/inc/Puma $(INCDIR)


#-------------------------------------------------
# special targets
#-------------------------------------------------

.PHONY: all dontweave config

#-------------------------------------------------
# includes
#-------------------------------------------------

ifeq ($(MAKECMDGOALS),)
ifneq ($(DEPFILES),)
-include $(DEPFILES)
endif
endif
