# include "charset.h"
# include "charconst.h"
# include <stdlib.h>
# include <iostream.h>

# define BIT_BLOCK(Char)   (Char / 32)
# define BIT_VAL(Char)     (1 << (Char % 32))

CharSet::CharSet (void)
 { 
   this->DeleteAll ();
 }

void CharSet::DeleteAll (void)
 { int Block;

   for (Block = 0; Block < 8; Block++)
      BitMap[Block] = 0;
 }

void CharSet::Insert (unsigned char From, unsigned char To)
 { unsigned char Start, End, Curr;

   if (From < To)
    { Start = From;
      End   = To;
    }
   else
    { Start = To;
      End   = From;
    }
   for (Curr = Start; Curr <= End; Curr++)
      BitMap[BIT_BLOCK(Curr)] |= BIT_VAL(Curr);
 }

int CharSet::In (unsigned char SearchedChar)
 { return (BitMap[BIT_BLOCK(SearchedChar)] &
	   BIT_VAL(SearchedChar)) != 0;
 }

int CharSet::IsEmpty (void)
 { int Block;

   for (Block = 0; Block < 8; Block++)
      if (BitMap[Block] != 0)
	 return 0;
   return 1;
 }

CharSet CharSet::operator+ (CharSet Chars)
 { int     Block;
   CharSet Sum;

   for (Block = 0; Block < 8; Block++)
      Sum.BitMap[Block] = this->BitMap[Block] | Chars.BitMap[Block];
   return Sum;
 }

CharSet CharSet::operator- (CharSet Chars)
 { int     Block;
   CharSet Without;

   for (Block = 0; Block < 8; Block++)
      Without.BitMap[Block] = this->BitMap[Block] & ~(Chars.BitMap[Block]);
   return Without;
 }


void CharSet::Print (void)
 { unsigned int Curr, Printed;
   unsigned char Buff[5], CurrChar;

   cout <<"{ ";
   for (Curr = 0, Printed = 0; Curr < 256; Curr++)
    { if (this->In (Curr))
       { if (Printed != 0)
	  { cout << ", ";
	    if (Printed % 8 == 0)
	       cout << "\n  ";
	  }
         CurrChar = (unsigned char)Curr;
	 CharToString (CurrChar, Buff);
	 cout << "\'" << Buff << "\'";
	 Printed++;
       }
    }
   cout << " }";
 }







