# ifndef __CLASSES__
# define __CLASSES__

# include <iostream.h>
# include "charset.h"

class ClassId
 { int Id;
 public:
   inline ClassId (void);
   inline ClassId (int Init);
   inline int GetId (void);
   inline void operator++ (int);
   inline int operator!= (ClassId CompareId);
   inline int operator== (ClassId CompareId);
   inline void Print (void);
 };

inline ClassId::ClassId (void)
 { Id = 0;
 }

inline ClassId::ClassId (int Init)
 { Id = Init;
 }

inline int ClassId::GetId (void)
 { return Id;
 }

inline void ClassId::operator++ (int)
 { Id++;
 }

inline int ClassId::operator!= (ClassId CompareId)
 { return (this->Id != CompareId.Id);
 }

inline int ClassId::operator== (ClassId CompareId)
 { return (this->Id == CompareId.Id);
 }

inline void ClassId::Print (void)
 { cout << "<" << Id << ">";
 }


struct ClassIdEntry
 { ClassId             Id;
   struct ClassIdEntry *Next;
 };


void NewClass (char* Name, CharSet Chars);
void NewSingleChar (char NewChar);
void PrintClasses (void);
void PrintRelationList (void);
ClassId FindClassId (char Char);
void ScanClassMap (void);
int NextEntry (int& Id, CharSet& Set);
void ScanIds (struct ClassIdEntry*& Context, char* Name);
struct ClassIdEntry* FindClassIds (struct ClassIdEntry*& Context, ClassId& Id);
void ScanClassIds (void);
int NextClassId (ClassId& Id);

# endif












